<?php
defined( 'ABSPATH' ) || exit;

function wacu_get_smart_messages() {
	global $wpdb;

	$smart_messages = array();

	if ( ! get_transient( 'wacu_smart_messages' ) ) {
		$query          = $wpdb->get_results(
			"SELECT
				post.ID as id,
				post.post_content as message,
				MAX( CASE WHEN postmeta.meta_key = 'post_type' THEN postmeta.meta_value END ) as post_type,
				MAX( CASE WHEN postmeta.meta_key = 'position' THEN postmeta.meta_value END ) as position,
				MAX( CASE WHEN postmeta.meta_key = 'status' THEN postmeta.meta_value END ) as status
			FROM {$wpdb->posts} as post, {$wpdb->postmeta} as postmeta
			WHERE post.ID = postmeta.post_id
				AND post.post_type = 'wacu_smart_message'
			GROUP BY post.ID
			ORDER BY position",
			ARRAY_A
		);

		foreach( $query as $q ) {
			$smart_messages[$q['id']] = $q;
		}

		set_transient( 'wacu_smart_messages', $smart_messages, DAY_IN_SECONDS );
	}

	return apply_filters( __FUNCTION__,  get_transient( 'wacu_smart_messages' ) );
}

function wacu_get_smart_message( $id, $data = '' ) {
	$smart_messages = wacu_get_smart_messages();

	if ( $data ) {
		if ( isset( $smart_messages[$id][$data] ) ) {
			return $smart_messages[$id][$data];
		}
	} if ( $id ) {
		if ( isset( $smart_messages[$id] ) ) {
			return $smart_messages[$id];
		}
	} else {
		return false;
	}
}
