<?php
defined( 'ABSPATH' ) || exit;

class WACU_Email_Us {

	public function __construct() {
		add_shortcode( 'wacu_email_us', array( $this, 'display_email_us' ) );
		add_action( 'wp_ajax_wacu_email_us_submit', array( $this, 'email_us_submit' ) );
		add_action( 'wp_ajax_nopriv_wacu_email_us_submit', array( $this, 'email_us_submit' ) );
	}

	/**
	 * Send email via ajax.
	 */
	public function email_us_submit() {
		if ( $_POST['wacu_email_us_security']
			&& wp_verify_nonce( $_POST['wacu_email_us_security'], 'wacu_email_us_submit' ) ) {
			// Default response
			$response = array(
				'status'  => 0,
				'message' => '',
			);

			// Form inputs
			$name    = sanitize_text_field( $_POST['wacu_email_us_name'] );
			$email   = sanitize_email( $_POST['wacu_email_us_email'] );
			$message = sanitize_textarea_field( $_POST['wacu_email_us_message'] );

			// Email us settings
			$to               = wacu_email_us_option( 'email_to' );
			$cc               = wacu_email_us_option( 'email_cc' );
			$bcc              = wacu_email_us_option( 'email_bcc' );
			$subject          = wacu_email_us_option( 'email_subject' );
			$email_body       = wacu_email_us_option( 'email_body' );
			$email_from_name  = wacu_email_us_option( 'email_from_name' );
			$email_from_email = wacu_email_us_option( 'email_from_email' );

			// Email data
			$subject = str_replace(
				array(
					'{{name}}',
					'{{current_time}}',
				),
				array(
					$name,
					wacu_get_current_time(),
				),
				$subject
			);

			$body = str_replace(
				array(
					'{{name}}',
					'{{email}}',
					'{{message}}',
					'{{page_title}}',
					'{{page_url}}',
					'{{current_time}}',
				),
				array(
					$name,
					$email,
					$message,
					$_POST['page_title'], // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					$_POST['page_url'], // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					wacu_get_current_time(),
				),
				wp_kses_post( wpautop( $email_body ) )
			);

			$headers[] = 'Content-Type: text/html; charset=UTF-8';

			// Set from header
			if ( $email_from_name && $email_from_email ) {
				$headers[] = 'From: ' . esc_html( $email_from_name ) . ' <' . esc_html( $email_from_email ) . '>';
			}

			// Set reply to
			$headers[] = "Reply-To: $name <$email>";

			// Set Cc
			if ( $cc ) {
				$headers[] = "Cc: $cc";
			}
			// Set Bcc
			if ( $bcc ) {
				$headers[] = "Bcc: $bcc";
			}

			$mail = wp_mail( $to, $subject, $body, $headers );

			if ( $mail ) {
				$response = array(
					'status'  => 1,
					'message' => str_replace(
						array(
							'{{name}}',
						),
						array(
							$name,
						),
						wp_kses_post( wacu_email_us_option( 'thank_you_message' ) )
					),
				);
			}

			echo wp_json_encode( $response );
		}
		wp_die();
	}

	/**
	 * Display email us form using shortcode.
	 *
	 * [wacu-email-us]
	 */
	public function display_email_us() {
		ob_start();
		require_once WACU_PLUGIN_PATH . '/templates/email-us.php';
		return ob_get_clean();
	}
}

new WACU_Email_Us;
