<?php defined( 'ABSPATH' ) || exit; ?>
<div class="wrap">
	<h1><?php esc_html_e( 'Google reCAPTCHA', 'wp-any-contact-us' );?></h1>
	<?php settings_errors();?>
	<hr>

	<form action="options.php" method="post">
		<?php settings_fields( 'wacu_grecaptcha_settings_option_group' );?>

		<h3><?php esc_html_e( 'Google reCAPTCHA v2', 'wp-any-contact-us' );?></h3>
		<table class="form-table">
			<tbody>
				<tr>
					<th scopr="row">
						<label for="wacu_grecaptcha_settings[v2_site_key]"><?php esc_html_e( 'Site Key', 'wp-any-contact-us' );?></label>
					</th>
					<td>
						<input
							type="text"
							id="wacu_grecaptcha_settings[v2_site_key]"
							class="regular-text"
							name="wacu_grecaptcha_settings[v2_site_key]"
							value="<?php echo esc_attr( wacu_grecaptcha_option( 'v2_site_key' ) ); ?>">
						<p class="description"><?php esc_html_e( 'Enter Google reCAPTCHA v2 Site Key', 'wp-any-contact-us' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scopr="row">
						<label for="wacu_grecaptcha_settings[v2_secret_key]"><?php esc_html_e( 'Secret key', 'wp-any-contact-us' );?></label>
					</th>
					<td>
						<input
							type="text"
							id="wacu_grecaptcha_settings[v2_secret_key]"
							class="regular-text"
							name="wacu_grecaptcha_settings[v2_secret_key]"
							value="<?php echo esc_attr( wacu_grecaptcha_option( 'v2_secret_key' ) ); ?>">
						<p class="description"><?php esc_html_e( 'Enter Google reCAPTCHA v2 Secret Key', 'wp-any-contact-us' ); ?></p>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<?php
							echo wp_kses_post(
								sprintf(
									__( 'Generate Google reCAPTCHA v2 keys from here: %s', 'wp-any-contact-us' ),
									'<a href="https://www.google.com/recaptcha/admin" target="_blank">https://www.google.com/recaptcha/admin</a>'
								)
							);
						?>
					</td>
				</tr>
			</tbody>
		</table>
		<?php submit_button();?>
	</form>

</div>
