( function ( $ ) {
	/**
	 * Modal for admin
	 */
	$.fn.wacuModal = function( options ) {
		var htmlOverflow = $( 'html' ).css( 'overflow' );
		var settings     = $.extend( {}, options );

		// Do for each modal
		$( this ).each( function( index, element ) {
			var modal        = $( element );
			var modalID      = $( element ).data( 'wacu-modal' );
			var modalTrigger = '[data-wacu-model-trigger="' + modalID + '"]';

			// open modal
			$( document ).on( 'click touch', modalTrigger, function( e ) {
				e.preventDefault();
				$( 'html' ).css( 'overflow', 'hidden' );

				$( document.body ).trigger( 'wacu_modal_open' );
				modal.addClass( 'wacu-model-show' );
			} );

			// close modal
			$( document ).on( 'click touch', '[data-wacu-modal-close], .wacu-modal-close, .wacu-modal-header > span', function( e ) {
				e.preventDefault();
				$( 'html' ).css( 'overflow', htmlOverflow );

				$( document.body ).trigger( 'wacu_modal_close' );
				modal.removeClass( 'wacu-model-show' );
			} );

			// Add close button in header
			$( '.wacu-modal-header', this ).append( '<span>x</span>' );
		} );
	};


}( jQuery ) );

( function( $ ) {
	"use strict";

	const loader = '<div class="wacu-folding-cube">' +
		'<div class="wacu-cube1 wacu-cube"></div>' +
		'<div class="wacu-cube2 wacu-cube"></div>' +
		'<div class="wacu-cube4 wacu-cube"></div>' +
		'<div class="wacu-cube3 wacu-cube"></div>' +
	'</div>';

	$( document ).ready( function() {
		// Constants
		const ajax_url = wacuAdminObj.ajax_url;

		// Plugins init
		$( '[data-wacu-modal]' ).wacuModal();
		$( '.wacu-color-picker' ).wpColorPicker();
		$( '.wacu-select2' ).select2();

		// Icon selector
		$( document ).on( 'click touch', '[data-wacu-icon-name]', function() {
			var uniqid  = $( this ).closest( '[data-wacu-selector]' ).attr( 'data-wacu-selector' );
			var icon    = $( this ).data( 'wacu-icon-name' );

			$( '[data-wacu-icon-input="'+uniqid+'"]' ).val( icon );
			$( '[data-wacu-selector="'+uniqid+'"]' ).hide();
		} );

		$( document ).on( 'focus', '[data-wacu-icon-input]', function() {
			var uniqid      = $( this ).data( 'wacu-icon-input' );
			var inputWidth  = $( this ).css( 'width' );

			$( '[data-wacu-selector="'+uniqid+'"]' ).show();
			$( '[data-wacu-selector="'+uniqid+'"]' ).css( 'width', inputWidth );
		} );

		$( document ).on( 'keyup', '[data-wacu-icon-input]', function() {
			var search = $( this ).val().toLowerCase();
			var uniqid = $( this ).data( 'wacu-icon-input' );

			$( '[data-wacu-selector="'+uniqid+'"] > .data-wacu-icon' ).each( function( i, e ) {
				var iconName = $( e ).data( 'wacu-icon-name' ).toLowerCase();

				if ( false == iconName.includes( search ) ) {
					$( e ).hide();
				} else {
					$( e ).show();
				}
			} );
		} );

		$( document ).on( 'focusout', '[data-wacu-icon-input]', function() {
			var uniqid      = $( this ).data( 'wacu-icon-input' );

			setTimeout( function() {
				$( '[data-wacu-selector="'+uniqid+'"]' ).hide();
			}, 300 );
		} );

		// Social contacts actions.
		$( document ).on( 'click touch', '[data-wacu-edit-social-contact]', function() {
			var ajaxContainer   = $( '#edit-social-contact' );
			var socialContactID = $( this ).data( 'wacu-edit-social-contact' );

			ajaxContainer.empty();
			ajaxContainer.html( loader );

			$.ajax( {
				url: ajax_url,
				type: 'post',
				data: {
					'action': 'wacu_edit_social_contact_form',
					'id': socialContactID,
				},
				success: function( response ) {
					ajaxContainer.html( response );
					$( '[name="wacu_social_contact[type]"]' ).change();
					$( '.wacu-color-picker' ).wpColorPicker();
				}
			} );
		} );

		$( document ).on( 'click touch', '[data-wacu-delete-social-contact]', function() {
			var socialContactID  = $( this ).data( 'wacu-delete-social-contact' );
			var socialContactRow = $( '[data-wacu-sc-id="' + socialContactID + '"' );

			socialContactRow.hide();

			$.ajax( {
				url: ajax_url,
				type: 'get',
				dataType: 'json',
				data: {
					'action': 'wacu_delete_social_contact',
					'wacu_delete_socail_contact': socialContactID,
				},
				success: function( response ) {
					if ( ! response.status ) {
						socialContactRow.show();
					}
				}
			} );
		} );

		$( document ).on( 'click touch', '[data-wacu-disable-social-contact]', function() {
			var socialContactID = $( this ).data( 'wacu-disable-social-contact' );

			$( '[data-wacu-disable-social-contact="' + socialContactID + '"]' ).hide();
			$( '[data-wacu-enable-social-contact="' + socialContactID + '"]' ).show();

			$.ajax( {
				url: ajax_url,
				type: 'post',
				dataType: 'json',
				data: {
					'action': 'wacu_disable_social_contact',
					'id': socialContactID,
				}
			} );
		} );

		$( document ).on( 'click touch', '[data-wacu-enable-social-contact]', function() {
			var socialContactID = $( this ).data( 'wacu-enable-social-contact' );

			$( '[data-wacu-disable-social-contact="' + socialContactID + '"]' ).show();
			$( '[data-wacu-enable-social-contact="' + socialContactID + '"]' ).hide();

			$.ajax( {
				url: ajax_url,
				type: 'post',
				dataType: 'json',
				data: {
					'action': 'wacu_enable_social_contact',
					'id': socialContactID,
				}
			} );
		} );

		$( document ).on( 'change', '[name="wacu_social_contact[type]"]', function() {
			var type           = $( this ).val();
			var linkRow        = $( '[name="wacu_social_contact[link]"]' );
			var linkTagretRow  = $( '[name="wacu_social_contact[target]"]' );
			var integrationRow = $( '[name="wacu_social_contact[integration]"]' );
			var contentRow     = $( '[name="wacu_social_contact[content]"]' );

			linkRow.closest( '.wacu-row' ).show();
			linkTagretRow.closest( '.wacu-row' ).show();
			integrationRow.closest( '.wacu-row' ).show();
			contentRow.closest( '.wacu-row' ).show();

			if ( '1' == type ) { // Link
				integrationRow.closest( '.wacu-row' ).hide();
				contentRow.closest( '.wacu-row' ).hide();
			}
			if ( '2' == type ) { // HTML/Shortcode
				linkRow.closest( '.wacu-row' ).hide();
				linkTagretRow.closest( '.wacu-row' ).hide();
				integrationRow.closest( '.wacu-row' ).hide();
			}
			if ( '3' == type ) { // Integration
				linkRow.closest( '.wacu-row' ).hide();
				linkTagretRow.closest( '.wacu-row' ).hide();
				contentRow.closest( '.wacu-row' ).hide();
			}

		} );

		$( "#wacu-admin-social-contact-table tbody" ).sortable( {
			placeholder : "ui-state-highlight",
			update: function( event, ui ) {
				var socialContactID = new Array();

				$( '#wacu-admin-social-contact-table [data-wacu-sc-id]' ).each( function() {
					socialContactID.push( $( this ).attr( "data-wacu-sc-id" ) );
				} );
				$.ajax( {
					url: ajax_url,
					method: "POST",
					data: {
						'action': 'wacu_sort_social_contacts',
						'social_contact_ids': socialContactID,
					},
				});
			}
		});

		// Smart message
		$( document ).on( 'click touch', '[data-wacu-edit-smart-message]', function() {
			var ajaxContainer   = $( '#edit-smart-message' );
			var smartMessageID = $( this ).data( 'wacu-edit-smart-message' );

			ajaxContainer.empty();
			ajaxContainer.html( loader );

			$.ajax( {
				url: ajax_url,
				type: 'post',
				data: {
					'action': 'wacu_edit_smart_message_form',
					'id': smartMessageID,
				},
				success: function( response ) {
					ajaxContainer.html( response );
				}
			} );
		} );

		$( document ).on( 'click touch', '[data-wacu-delete-smart-message]', function() {
			var smartMessageID  = $( this ).data( 'wacu-delete-smart-message' );
			var smartMessageRow = $( '[data-wacu-sm-id="' + smartMessageID + '"' );

			smartMessageRow.hide();

			$.ajax( {
				url: ajax_url,
				type: 'get',
				dataType: 'json',
				data: {
					'action': 'wacu_delete_smart_message',
					'wacu_delete_smart_message': smartMessageID,
				},
				success: function( response ) {
					if ( ! response.status ) {
						smartMessageRow.show();
					}
				}
			} );
		} );

		$( document ).on( 'click touch', '[data-wacu-disable-smart-message]', function() {
			var smartMessageID = $( this ).data( 'wacu-disable-smart-message' );

			$( '[data-wacu-disable-smart-message="' + smartMessageID + '"]' ).hide();
			$( '[data-wacu-enable-smart-message="' + smartMessageID + '"]' ).show();

			$.ajax( {
				url: ajax_url,
				type: 'post',
				dataType: 'json',
				data: {
					'action': 'wacu_disable_smart_message',
					'id': smartMessageID,
				}
			} );
		} );

		$( document ).on( 'click touch', '[data-wacu-enable-smart-message]', function() {
			var smartMessageID = $( this ).data( 'wacu-enable-smart-message' );

			$( '[data-wacu-disable-smart-message="' + smartMessageID + '"]' ).show();
			$( '[data-wacu-enable-smart-message="' + smartMessageID + '"]' ).hide();

			$.ajax( {
				url: ajax_url,
				type: 'post',
				dataType: 'json',
				data: {
					'action': 'wacu_enable_smart_message',
					'id': smartMessageID,
				}
			} );
		} );

		$( "#wacu-admin-smart-message-table tbody" ).sortable( {
			placeholder : "ui-state-highlight",
			update: function( event, ui ) {
				var smartMessageID = new Array();

				$( '#wacu-admin-smart-message-table [data-wacu-sm-id]' ).each( function() {
					smartMessageID.push( $( this ).data( "wacu-sm-id" ) );
				} );
				$.ajax( {
					url: ajax_url,
					method: "POST",
					data: {
						'action': 'wacu_sort_smart_messages',
						'smart_message_ids': smartMessageID,
					},
				});
			}
		});

		// Socail contact selector
		$( '#wacu-search-social-contact' ).on( 'keyup', function() {
			var search = $( this ).val();

			$( '[data-wacu-sc-select]' ).each( function( i, e ) {
				var socialContact = $( e ).data( 'wacu-sc-select' );

				if ( socialContact.includes( search ) ) {
					$( e ).show();
				} else {
					$( e ).hide();
				}

			} );

		} );

		$( '[data-wacu-sc-select]' ).on( 'click touch', function() {
			if ( '' === $( this ).attr( 'data-wacu-sc-disabled' ) ) {
				return;
			}

			var socialContactName   = $( this ).data( 'wacu-sc-select' );
			var icon                = $( '[name="wacu_social_contact[icon]"]' );
			var iconColor           = $( '[name="wacu_social_contact[icon_color]"]' );
			var link                = $( '[name="wacu_social_contact[link]"]' );
			var target              = $( '[name="wacu_social_contact[target]"]' );
			var content             = $( '[name="wacu_social_contact[content]"]' );
			var type                = $( '[name="wacu_social_contact[type]"]' );
			var integration         = $( '[name="wacu_social_contact[integration]"]' );

			// Reset
			icon.val( '' );
			iconColor.val( '#3F406A' );
			link.val( '' );
			content.val( '' );
			type.val( '1' );
			target.val( '_blank' );
			integration.val( '0' );

			const socialcontactData = {
				whatsapp: {
					icon: 'whatsapp',
					iconColor: '#25D366',
					link: 'https://api.whatsapp.com/send?phone=ENTER_YOUR_NUMBER_HERE_WITHOUT_+_OR_00&text={{page_title}} - {{page_url}}',
					target: '_blank',
					type: 1,
				},
				facebook: {
					icon: 'facebook',
					iconColor: '#3b5999',
					link: 'https://fb.com/ENTER_YOUR_FACEBOOK_ID_OR_USERNAME_HERE',
					target: '_blank',
					type: 1,
				},
				instagram: {
					icon: 'instagram',
					iconColor: '#e4405f',
					link: 'https://instagram.com/ENTER_YOUR_INSTAGRAM_USERNAME_HERE',
					target: '_blank',
					type: 1,
				},
				twitter: {
					icon: 'twitter',
					iconColor: '#55acee',
					link: 'https://twitter.com/ENTER_YOUR_TWITTER_USERNAME_HERE',
					target: '_blank',
					type: 1,
				},
				facebook_messenger: {
					icon: 'facebook-messenger',
					iconColor: '#0084ff',
					link: 'https://m.me/ENRER_YOUR_FB_MESSENGER_USERNAME',
					target: '_blank',
					type: 1,
				},
				telegram: {
					icon: 'telegram-plane',
					iconColor: '#39AFE2',
					link: 'https://t.me/ENTER_YOUR_NUMBER_HERE_WITH_COUNTRY_CODE',
					target: '_blank',
					type: 1,
				},
				viber: {
					icon: 'viber',
					iconColor: '#665CAC',
					link: 'viber://chat?number=%2BENTER_VIBER_NUMBER_WITH_COUNTRY_CODE',
					target: '_blank',
					type: 1,
				},
				skype: {
					icon: 'skype',
					iconColor: '#00AFF0',
					link: 'skype:ENTER_YOUR_SKYPE_NICKNAME_HERE?chat',
					target: '_self',
					type: 1,
				},
				linkedin: {
					icon: 'linkedin-in',
					iconColor: '#0077B5',
					link: 'https://www.linkedin.com/in/ENTER_YOUR_LINKEDIN_USERNAME_HERE',
					target: '_blank',
					type: 1,
				},
				vk: {
					icon: 'vk',
					iconColor: '#4c75a3',
					link: 'https://vk.com/ENTER_YOUR_VK_USERNAME_HERE',
					target: '_blank',
					type: 1,
				},
				behance: {
					icon: 'behance',
					iconColor: '#131418',
					link: 'https://www.behance.net/ENTER_YOUR_BEHANCE_USERNAME_HERE',
					target: '_blank',
					type: 1,
				},
				dribbble: {
					icon: 'dribbble',
					iconColor: '#ea4c89',
					link: 'http://dribbble.com/ENTERT_YOUR_DRIBBBLE_USERNAME_HERE',
					target: '_blank',
					type: 1,
				},
				email: {
					icon: 'envelope',
					iconColor: '#FF4F4F',
					link: 'mailto:YOUR_EMAIL@ADDRESS.COM',
					target: '_self',
					type: 1,
				},
				callus: {
					icon: 'phone-volume',
					iconColor: '#E91E63',
					link: 'tel:ENTER_YOUR_PHONE_NUMBER_WITH_COUNTRY_CODE',
					target: '_self',
					type: 1,
				},
				sms: {
					icon: 'sms',
					iconColor: '#28CB00',
					link: 'sms:ENTER_YOUR_PHONE_NUMBER_WITH_COUNTRY_CODE',
					target: '_self',
					type: 1,
				},
				email_us_form: {
					icon: 'envelope',
					iconColor: '#FF4F4F',
					content: '[wacu_email_us]',
					target: '_self',
					type: 2,
				},
				schedule_call_form: {
					icon: 'phone-alt',
					iconColor: '#4185F2',
					content: '[wacu_schedule_call]',
					target: '_self',
					type: 2,
				},
				html: {
					icon: 'html5',
					iconColor: '#FF2E2E',
					content: '',
					target: '_self',
					type: 2,
				},
				shortcode: {
					icon: 'code',
					iconColor: '#3F406A',
					content: '',
					target: '_self',
					type: 2,
				},
				facebook_customer_chat: {
					icon: 'facebook-messenger',
					iconColor: '#0084ff',
					content: '',
					target: '_self',
					type: 3,
					integration: 'facebook_customer_chat',
				},
				tawk_to: {
					icon: 'comments',
					iconColor: '#03a84e',
					content: '',
					target: '_self',
					type: 3,
					integration: 'tawk_to',
				},
				wordpress_whatsapp_support: {
					icon: 'whatsapp',
					iconColor: '#25d366',
					content: '',
					target: '_self',
					type: 3,
					integration: 'wordpress_whatsapp_support',
				}
			}

			$.each( socialcontactData, function( i, e ) {
				if ( socialContactName == i ) {
					icon.val( e.icon );
					iconColor.val( e.iconColor );
					link.val( e.link );
					target.val( e.target );
					content.val( e.content );
					type.val( e.type );
					integration.val( e.integration );
				}
			} );

			$( '.wacu-social-contact-selector' ).hide();
			$( '.wacu-add-social-contact-form' ).show();
			$( '[name="wacu_social_contact[type]"]' ).change();
			iconColor.change();
		} )

		$( document.body ).on( 'wacu_modal_close', function() {
			$( '.wacu-social-contact-selector' ).show();
			$( '.wacu-add-social-contact-form' ).hide();
			$( '[data-wacu-sc-select]' ).show();
			$( '#wacu-search-social-contact' ).val( '' );
		} );

		/**
		 * Field condition based on trigger type.
		 *
		 * @since 1.1.8
		 */
		function wacuTriggerTypeConditions() {
			var triggerType = $( '[name="wacu_appearance_settings[trigger_type]"]' ).val();

			if ( 'icon_only' === triggerType ) {
				$( '[name="wacu_appearance_settings[trigger_size]"]' ).closest( 'tr' ).show();
				$( '[name="wacu_appearance_settings[trigger_icon_size]"]' ).closest( 'tr' ).show();
				$( '[name="wacu_appearance_settings[trigger_effect]"]' ).closest( 'tr' ).show();
				$( '[name="wacu_appearance_settings[trigger_text]"]' ).closest( 'tr' ).hide();
			} else {
				$( '[name="wacu_appearance_settings[trigger_size]"]' ).closest( 'tr' ).hide();
				$( '[name="wacu_appearance_settings[trigger_icon_size]"]' ).closest( 'tr' ).hide();
				$( '[name="wacu_appearance_settings[trigger_text]"]' ).closest( 'tr' ).show();
				$( '[name="wacu_appearance_settings[trigger_effect]"]' ).closest( 'tr' ).hide();


			}
		}

		// Run on change trigger type.
		$( '[name="wacu_appearance_settings[trigger_type]"]' ).on( 'change', wacuTriggerTypeConditions );

		// Run with doc ready.
		wacuTriggerTypeConditions();

	} ); // End documnet ready.

} )( jQuery )
