<?php

class DSM_Mega_Menu_Child extends ET_Builder_Module {
	public $slug       = 'dsm_mega_menu_child';
	public $vb_support = 'on';

	protected $module_credits = array(
		'module_uri' => 'https://divisupreme.com/',
		'author'     => 'Divi Supreme',
		'author_uri' => 'https://divisupreme.com/',
	);

	public function init() {
		$this->name                        = esc_html__( 'Mega Menu Child', 'supreme-mega-menu' );
		$this->type                        = 'child';
		$this->child_title_var             = 'dsm_admin_label';
		$this->advanced_setting_title_text = esc_html__( 'Mega Menu', 'supreme-mega-menu' );

		$this->settings_modal_toggles = array(
			'general'    => array(
				'toggles' => array(
					'content'            => esc_html__( 'Content', 'supreme-mega-menu' ),
					'dsm_image_panel'    => esc_html__( 'Image & Icon', 'supreme-mega-menu' ),
					'dsm_element_panel'  => esc_html__( 'Elements', 'supreme-mega-menu' ),
					'dsm_dropdown_panel' => esc_html__( 'Dropdown', 'supreme-mega-menu' ),
					'dsm_link_panel'     => esc_html__( 'Link', 'supreme-mega-menu' ),
					'dsm_admin_panel'    => esc_html__( 'Admin Label', 'supreme-mega-menu' ),
				),
			),

			'advanced'   => array(
				'toggles' => array(
					'alignment'            => esc_html__( 'Alignment', 'supreme-mega-menu' ),
					'dsm_menu_panel'       => esc_html__( 'Menu', 'supreme-mega-menu' ),
					'title_typo'           => esc_html__( 'Title Text', 'supreme-mega-menu' ),
					'dsm_menu_panel'       => esc_html__( 'Menu', 'supreme-mega-menu' ),
					'dsm_submenu_panel'    => esc_html__( 'Sub Menu Text', 'supreme-mega-menu' ),
					'dsm_badge_panel'      => esc_html__( 'Badge', 'supreme-mega-menu' ),
					'dsm_dropdown_panel'   => esc_html__( 'Dropdown', 'supreme-mega-menu' ),
					'dsm_arrow_panel'      => esc_html__( 'Arrow', 'supreme-mega-menu' ),
					'dsm_image_icon_panel' => esc_html__( 'Image & Icon', 'supreme-mega-menu' ),
					'dsm_cart_icon_panel'  => esc_html__( 'Cart Count', 'supreme-mega-menu' ),
				),
			),

			'custom_css' => array(
				'toggles' => array(
					'animation'  => array(
						'title'    => esc_html__( 'Animation', 'supreme-mega-menu' ),
						'priority' => 90,
					),
					'attributes' => array(
						'title'    => esc_html__( 'Attributes', 'supreme-mega-menu' ),
						'priority' => 95,
					),
				),
			),
		);

		$this->advanced_fields = array(

			'fonts'        => array(

				'dsm_menu_text' => array(
					'label'           => esc_html__( 'Menu Text', 'supreme-mega-menu' ),
					'css'             => array(
						'main'      => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text',
						'important' => 'all',
					),

					'font_size'       => array(
						'default' => '14px',
					),

					'line_height'     => array(
						'default' => '1.7em',
					),

					'letter_spacing'  => array(
						'default' => '0px',
					),

					'hide_text_color' => true,

					'tab_slug'        => 'advanced',
					'toggle_slug'     => 'dsm_menu_panel',
				),
			),

			'borders'      => array(
				'default'               => array(
					'css'         => array(
						'main' => array(
							'border_radii'  => '%%order_class%%',
							'border_styles' => '%%order_class%%',
							'important'     => 'all',
						),
					),
					'tab_slug'    => 'advanced',
					'toggle_slug' => 'card',

				),

				'dsm_menu_item_border'  => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-mega-menu-link',
							'border_styles' => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-mega-menu-link',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_menu_panel',
				),

				'dsm_badge_item_border' => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-badge-text',
							'border_styles' => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-badge-text',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_badge_panel',
				),

				'dsm_dropdown_border'   => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%  .dsm-submenu-container .dsm-submenu-inner-container',
							'border_styles' => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%  .dsm-submenu-container .dsm-submenu-inner-container',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_dropdown_panel',
				),

				'dsm_submenu_border'    => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item.dsm-native-menu ul',
							'border_styles' => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item.dsm-native-menu ul',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_submenu_panel',
				),

				'dsm_image_icon_border' => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
							'border_styles' => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_image_icon_panel',
				),

				'dsm_cart_count_border' => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
							'border_styles' => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
						),
					),

					'label_prefix' => esc_html__( '', 'supreme-mega-menu' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'dsm_cart_icon_panel',
				),
			),

			'box_shadow'   => array(
				'default'               => array(
					'css'         => array(
						'main'      => '%%order_class%%',
						'important' => 'all',
					),
					'tab_slug'    => 'advanced',
					'toggle_slug' => 'card',
				),

				'dsm_menu_item_shadow'  => array(
					'css'         => array(
						'main'      => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link',
						'important' => 'all',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_menu_panel',
				),

				'dsm_badge_item_shadow' => array(
					'css'         => array(
						'main' => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-badge-text',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_badge_panel',
				),

				'dsm_dropdown_shadow'   => array(
					'css'         => array(
						'main' => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item  .dsm-submenu-container .dsm-submenu-inner-container',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_dropdown_panel',
				),

				'dsm_submenu_shadow'    => array(
					'css'         => array(
						'main' => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item.dsm-native-menu ul li',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_submenu_panel',
				),

				'dsm_image_icon_shadow' => array(
					'css'         => array(
						'main' => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%  .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_image_icon_panel',
				),

				'dsm_cart_count_shadow' => array(
					'css'         => array(
						'main' => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					),

					'tab_slug'    => 'advanced',
					'toggle_slug' => 'dsm_cart_icon_panel',
				),
			),

			'background'   => array(
				'css' => array(
					'main'      => '%%order_class%%',
					'important' => 'all',
				),
			),

			'text'         => false,
			'link_options' => false,
			'animation'    => false,
			'max_width'    => false,
			'filters'      => false,
			'transform'    => false,
		);
	}

	public function get_fields() {
		return array(

			'dsm_woo_cart_count'           => array(
				'label'           => esc_html__( 'Cart Count', 'supreme-mega-menu' ),
				'type'            => 'hidden',
				'default'         => $this->get_woo_cart_count(),
				'option_category' => 'basic_option',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
				'toggle_slug'     => 'content',
			),

			'dsm_admin_label'              => array(
				'label'            => esc_html__( 'Label', 'supreme-mega-menu' ),
				'type'             => 'text',
				'default_on_child' => true,
				'default'          => 'Mega Menu Item',
				'option_category'  => 'basic_option',
				'description'      => esc_html__( '', 'supreme-mega-menu' ),
				'tab_slug'         => 'general',
				'toggle_slug'      => 'dsm_admin_panel',
			),

			'dsm_menu_label'               => array(
				'label'            => esc_html__( 'Label', 'supreme-mega-menu' ),
				'type'             => 'text',
				'default_on_child' => true,
				'default'          => '',
				'option_category'  => 'basic_option',
				'dynamic_content'  => 'text',
				'description'      => esc_html__( '', 'supreme-mega-menu' ),
				'toggle_slug'      => 'content',
			),

			'dsm_content_type'             => array(
				'label'           => esc_html__( 'Content Type', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'link',
				'option_category' => 'configuration',
				'options'         => array(
					'link'        => esc_html__( 'Link', 'supreme-mega-menu' ),
					'native_menu' => esc_html__( 'WordPress Menu', 'supreme-mega-menu' ),
					'divi_layout' => esc_html__( 'Divi Layout', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_link'                     => array(
				'label'            => esc_html__( 'Link', 'supreme-mega-menu' ),
				'type'             => 'text',
				'default_on_child' => true,
				'default'          => '',
				'option_category'  => 'basic_option',
				'dynamic_content'  => 'text',
				'description'      => esc_html__( '', 'supreme-mega-menu' ),
				'toggle_slug'      => 'dsm_link_panel',

			),

			'dsm_link_target'              => array(
				'label'           => esc_html__( 'Link Target', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'link',
				'option_category' => 'configuration',
				'options'         => array(
					'same'     => esc_html__( 'In The Same Window', 'supreme-mega-menu' ),
					'new_page' => esc_html__( 'In the New Tab', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_link_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_native_menu'              => array(
				'label'           => esc_html__( 'WordPress Menu', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'none',
				'option_category' => 'configuration',
				'options'         => $this->get_nav_menu_options(),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
				'show_if'         => array(
					'dsm_content_type' => 'native_menu',
				),
			),

			'dsm_library_layout'           => array(
				'label'           => esc_html__( 'Layouts', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'select',
				'option_category' => 'configuration',
				'options'         => $this->get_layouts(),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'content',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
				'show_if'         => array(
					'dsm_content_type' => 'divi_layout',
				),
			),

			'dsm_show_woo_cart_count'      => array(
				'label'           => esc_html__( 'Show WooCommerce Cart Count', 'supreme-mega-menu' ),
				'type'            => 'yes_no_button',
				'option_category' => 'basic_option',
				'default'         => 'off',
				'options'         => array(
					'off' => esc_html__( 'No', 'supreme-mega-menu' ),
					'on'  => esc_html__( 'Yes', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_element_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_woo_notice'               => array(
				'type'        => 'warning',
				'value'       => class_exists( 'woocommerce' ) ? true : false,
				'display_if'  => false,
				'message'     => 'WooCommerce is not installed, Cart Count will work If WooCommerce is active on your site',
				'toggle_slug' => 'dsm_element_panel',

				'show_if'     => array(
					'dsm_show_woo_cart_count' => 'on',
				),
			),

			'dsm_cart_font_icon'           => array(
				'label'           => esc_html__( 'Cart Icon', 'supreme-mega-menu' ),
				'type'            => 'select_icon',
				'option_category' => 'basic_option',
				'default'         => '',
				'class'           => array( 'et-pb-font-icon' ),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_element_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),

				'show_if'         => array(
					'dsm_show_woo_cart_count' => 'on',
				),
			),

			'dsm_cart_icon_color'          => array(
				'label'          => esc_html__( 'Icon Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_cart_icon_panel',

				'show_if'        => array(
					'dsm_show_woo_cart_count' => 'on',
				),
			),

			'dsm_cart_icon_font_size'      => array(
				'label'           => esc_html__( 'Icon Font Size', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_cart_icon_panel',

				'show_if'         => array(
					'dsm_show_woo_cart_count' => 'on',
				),
			),

			'dsm_cart_count_color'         => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_cart_icon_panel',

				'show_if'        => array(
					'dsm_show_woo_cart_count' => 'on',
				),
			),

			'dsm_cart_count_bg_color'      => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_cart_icon_panel',

				'show_if'        => array(
					'dsm_show_woo_cart_count' => 'on',
				),
			),

			'dsm_cart_count_margin'        => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_cart_icon_panel',
				'mobile_options'  => true,
				'responsive'      => true,

				'show_if'         => array(
					'dsm_show_woo_cart_count' => 'on',
				),
			),

			'dsm_cart_count_padding'       => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_cart_icon_panel',
				'mobile_options'  => true,
				'responsive'      => true,

				'show_if'         => array(
					'dsm_show_woo_cart_count' => 'on',
				),
			),

			'dsm_use_image_icon'           => array(
				'label'           => esc_html__( 'Use Icon / Image', 'supreme-mega-menu' ),
				'type'            => 'yes_no_button',
				'option_category' => 'basic_option',
				'default'         => 'off',
				'options'         => array(
					'off' => esc_html__( 'No', 'supreme-mega-menu' ),
					'on'  => esc_html__( 'Yes', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_image_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_image'                    => array(
				'label'              => esc_html__( 'Image', 'supreme-mega-menu' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'default'            => '',
				'dynamic_content'    => 'image',
				'upload_button_text' => esc_attr__( 'Upload an image', 'supreme-mega-menu' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'supreme-mega-menu' ),
				'update_text'        => esc_attr__( 'Set As Image', 'supreme-mega-menu' ),
				'description'        => esc_html__( '', 'supreme-mega-menu' ),
				'toggle_slug'        => 'dsm_image_panel',

				'show_if'            => array(
					'dsm_use_icon'       => 'off',
					'dsm_use_image_icon' => 'on',
				),
			),

			'dsm_use_icon'                 => array(
				'label'           => esc_html__( 'Use Icon', 'supreme-mega-menu' ),
				'type'            => 'yes_no_button',
				'option_category' => 'basic_option',
				'default'         => 'off',
				'options'         => array(
					'off' => esc_html__( 'No', 'supreme-mega-menu' ),
					'on'  => esc_html__( 'Yes', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_image_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),

				'show_if'         => array(
					'dsm_use_image_icon' => 'on',
				),
			),

			'font_icon'                    => array(
				'label'           => esc_html__( 'Icon', 'supreme-mega-menu' ),
				'type'            => 'select_icon',
				'option_category' => 'basic_option',
				'default'         => '',
				'class'           => array( 'et-pb-font-icon' ),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_image_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),

				'show_if'         => array(
					'dsm_use_icon'       => 'on',
					'dsm_use_image_icon' => 'on',
				),
			),

			'dsm_image_icon_alignment'     => array(
				'label'           => esc_html__( 'Image / Icon Alignment', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'left',
				'option_category' => 'configuration',
				'options'         => array(
					'left'  => esc_html__( 'left', 'supreme-mega-menu' ),
					'right' => esc_html__( 'Right', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_image_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),

				'show_if'         => array(
					'dsm_use_image_icon' => 'on',
				),
			),

			'dsm_dropdown_open_font_icon'  => array(
				'label'           => esc_html__( 'Open Icon', 'supreme-mega-menu' ),
				'type'            => 'select_icon',
				'option_category' => 'basic_option',
				'default'         => '2',
				'class'           => array( 'et-pb-font-icon' ),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_dropdown_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),

				'show_if_not'     => array(
					'dsm_content_type' => 'link',
				),
			),

			'dsm_dropdown_close_font_icon' => array(
				'label'           => esc_html__( 'Close Icon', 'supreme-mega-menu' ),
				'type'            => 'select_icon',
				'option_category' => 'basic_option',
				'default'         => '3',
				'class'           => array( 'et-pb-font-icon' ),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_dropdown_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),

				'show_if_not'     => array(
					'dsm_content_type' => 'link',
				),
			),

			'dsm_dropdown_icon_position'   => array(
				'label'           => esc_html__( 'Position', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'right',
				'option_category' => 'configuration',
				'options'         => array(
					'left'  => esc_html__( 'Left', 'supreme-mega-menu' ),
					'right' => esc_html__( 'Right', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'general',
				'toggle_slug'     => 'dsm_dropdown_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),

				'show_if_not'     => array(
					'dsm_content_type' => 'link',
				),
			),

			'dsm_badge_text'               => array(
				'label'            => esc_html__( 'Badge Text', 'supreme-mega-menu' ),
				'type'             => 'text',
				'default_on_child' => true,
				'default'          => '',
				'option_category'  => 'basic_option',
				'dynamic_content'  => 'text',
				'description'      => esc_html__( '', 'supreme-mega-menu' ),
				'toggle_slug'      => 'content',
			),

			'dsm_badge_position'           => array(
				'label'           => esc_html__( 'Position', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => 'left',
				'option_category' => 'configuration',
				'options'         => array(
					'relative' => esc_html__( 'Relative', 'supreme-mega-menu' ),
					'absolute' => esc_html__( 'Absolute', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_badge_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_badge_top_pos'            => array(
				'label'           => esc_html__( 'Top', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '0%',
				'default_unit'    => '%',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_badge_panel',

				'show_if'         => array(
					'dsm_badge_position' => 'absolute',
				),
			),

			'dsm_badge_left_pos'           => array(
				'label'           => esc_html__( 'Left', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '0%',
				'default_unit'    => '%',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_badge_panel',

				'show_if'         => array(
					'dsm_badge_position' => 'absolute',
				),
			),

			'dsm_badge_text_color'         => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_badge_panel',
			),

			'dsm_badge_text_bg_color'      => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'tab_slug'       => 'advanced',
				'hover'          => 'tabs',
				'toggle_slug'    => 'dsm_badge_panel',
			),

			'dsm_badge_margin'             => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_badge_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_badge_padding'            => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_badge_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_dropdown_width'           => array(
				'label'           => esc_html__( 'Vertical Dropdown Width', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '1200',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
			),

			'dsm_dropdown_gap'             => array(
				'label'           => esc_html__( 'Vertical Dropdown Gap', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '150',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
			),

			'dsm_width'                    => array(
				'label'           => esc_html__( 'Horizontal Dropdown width', 'supreme-mega-menu' ),
				'type'            => 'select',
				'default'         => '',
				'option_category' => 'configuration',
				'options'         => array(
					'container'    => esc_html__( 'Container', 'supreme-mega-menu' ),
					'fullwidth'    => esc_html__( 'Fullwidth', 'supreme-mega-menu' ),
					'custom_width' => esc_html__( 'Custom Width', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_custom_width'             => array(
				'label'           => esc_html__( 'Horizontal Custom Width', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '200px',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '1000',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',

				'show_if'         => array(
					'dsm_width' => 'custom_width',
				),
			),

			'dsm_use_custom_height'        => array(
				'label'           => esc_html__( 'Custom Height', 'supreme-mega-menu' ),
				'type'            => 'yes_no_button',
				'option_category' => 'basic_option',
				'default'         => 'off',
				'options'         => array(
					'off' => esc_html__( 'No', 'supreme-mega-menu' ),
					'on'  => esc_html__( 'Yes', 'supreme-mega-menu' ),
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
				'description'     => esc_html__( '', 'supreme-mega-menu' ),
			),

			'dsm_dropdown_height'          => array(
				'label'           => esc_html__( 'Height', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '500px',
				'default_unit'    => 'px',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '1000',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',

				'show_if'         => array(
					'dsm_use_custom_height' => 'on',
				),
			),

			'dsm_dropdown_icon_color'      => array(
				'label'          => esc_html__( 'Icon Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_dropdown_panel',
			),

			'dsm_dropdown_icon_font_size'  => array(
				'label'           => esc_html__( 'Icon Font Size', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '100',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
			),

			'dsm_dropdown_bg_color'        => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_dropdown_panel',
			),

			'dsm_dropdown_margin'          => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_dropdown_padding'         => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_dropdown_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_image_width'              => array(
				'label'           => esc_html__( 'Width', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '150',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',

				'show_if'         => array(
					'dsm_use_image_icon' => 'on',
					'dsm_use_icon'       => 'off',
				),
			),

			'dsm_icon_font_size'           => array(
				'label'           => esc_html__( 'Font Size', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '150',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',

				'show_if'         => array(
					'dsm_use_image_icon' => 'on',
					'dsm_use_icon'       => 'on',
				),
			),

			'dsm_icon_color'               => array(
				'label'          => esc_html__( 'Icon Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_image_icon_panel',
			),

			'dsm_image_icon_bg_color'      => array(
				'label'          => esc_html__( 'Image Icon Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_image_icon_panel',
			),

			'dsm_image_icon_margin'        => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_image_icon_padding'       => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_image_width'              => array(
				'label'           => esc_html__( 'Width', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '150',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',
			),

			'dsm_icon_font_size'           => array(
				'label'           => esc_html__( 'Font Size', 'supreme-mega-menu' ),
				'type'            => 'range',
				'option_category' => 'font_option',
				'default'         => '',
				'mobile_options'  => true,
				'responsive'      => true,
				'range_settings'  => array(
					'min'  => '1',
					'max'  => '150',
					'step' => '1',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',
			),

			'dsm_icon_color'               => array(
				'label'          => esc_html__( 'Icon Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_image_icon_panel',
			),

			'dsm_image_icon_bg_color'      => array(
				'label'          => esc_html__( 'Image Icon Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_image_icon_panel',
			),

			'dsm_image_icon_margin'        => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_image_icon_padding'       => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_image_icon_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_submenu_color'            => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_submenu_panel',
			),

			'dsm_submenu_bg_color'         => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_submenu_panel',
			),

			'dsm_submenu_margin'           => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_submenu_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_submenu_padding'          => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_submenu_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_menu_item_color'          => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_menu_panel',
			),

			'dsm_menu_item_bg_color'       => array(
				'label'          => esc_html__( 'Bg Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'hover'          => 'tabs',
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_menu_panel',
			),

			'dsm_menu_item_margin'         => array(
				'label'           => esc_html__( 'Margin', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_menu_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_menu_item_padding'        => array(
				'label'           => esc_html__( 'Padding', 'supreme-mega-menu' ),
				'type'            => 'custom_margin',
				'option_category' => 'basic_option',
				'default'         => '',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'dsm_menu_panel',
				'mobile_options'  => true,
				'responsive'      => true,
			),

			'dsm_arrow_color'              => array(
				'label'          => esc_html__( 'Color', 'supreme-mega-menu' ),
				'type'           => 'color-alpha',
				'description'    => esc_html__( '', 'supreme-mega-menu' ),
				'default'        => '',
				'mobile_options' => true,
				'responsive'     => true,
				'tab_slug'       => 'advanced',
				'toggle_slug'    => 'dsm_arrow_panel',
			),
		);
	}

	private function get_layouts() {

		$layouts           = array();
		$available_layouts = get_posts(
			array(
				'post_type'      => 'et_pb_layout',
				'posts_per_page' => -1,
			)
		);

		foreach ( $available_layouts as $layout ) {

			$types               = wp_get_post_terms( $layout->ID, 'layout_type' );
			$current_layout_type = $types[0]->name;

			$layouts[ sprintf( '%1$s|%2$s', $layout->ID, $current_layout_type ) ] = empty( $layout->post_title ) ? 'Unknown Layout ' . $layout->ID : $layout->post_title;
		}

		$empty_layouts = array(
			'-1' => 'No Layouts found',
		);

		$final_layouts = empty( $layouts ) ? $empty_layouts : $layouts;

		if ( ! empty( $layouts ) ) {
			$final_layouts['select'] = 'Select Layout';
		}

		return $final_layouts;
	}

	public function recursive_merge_child_menu( $menu_items, $menu ) {
		$found_child = array();

		foreach ( $menu_items as $curr_menu_item ) {
			if ( (int) $curr_menu_item->menu_item_parent === $menu->ID ) {
				$found_child[] = array(
					'title'    => $curr_menu_item->title,
					'link'     => $curr_menu_item->url,
					'children' => $this->recursive_merge_child_menu( $menu_items, $curr_menu_item ),
				);
			}
		}

		return $found_child;
	}

	public function organize_menu_items( $menu_items ) {
		$final_menu_items = array();

		foreach ( $menu_items as $menu_item ) {
			$is_sub_item = $menu_item->menu_item_parent !== '0';
			$title       = $menu_item->title;
			$link        = $menu_item->url;
			$menu_id     = $menu_item->ID;

			if ( $is_sub_item ) {
				continue;
			}

			$final_menu_items[] = array(
				'title'    => $title,
				'link'     => $link,
				'children' => $this->recursive_merge_child_menu( $menu_items, $menu_item ),
			);
		}

		return $final_menu_items;
	}


	/**
	 * Obtains WP Native menu options.
	 *
	 * @return array
	 */
	public function get_nav_menu_options() {

		$nav_menu_options = array(
			'none' => 'Select a menu',
		);

		$nav_menus = wp_get_nav_menus( array( 'orderby' => 'name' ) );

		foreach ( (array) $nav_menus as $_nav_menu ) {
			$nav_menu_options[ $_nav_menu->term_id ] = $_nav_menu->name;
		}

		return $nav_menu_options;
	}

	/**
	 * Renders the native WP menu item.
	 *
	 * @return string
	 */
	public function render_native_menu_item( $menu_item ) {
		global $dsm_dropdown_animation, $dsm_trigger;

		$multi_view = et_pb_multi_view_options( $this );
		$child_menu = '';
		$childrens  = isset( $menu_item['children'] ) ? $menu_item['children'] : array();

		foreach ( $childrens as $child_menu_item ) {
			if ( empty( $child_menu_item ) ) {
				continue;
			}

			$rendered_child_menu = $this->render_native_menu_item( $child_menu_item );
			$child_menu         .= $rendered_child_menu;
		}

		$dropdown_icon = $multi_view->render_element(
			array(
				'tag'     => 'span',
				'content' => '{{dsm_dropdown_close_font_icon}}',
				'attrs'   => array(
					'class' => 'dsm_dropdown_icon',
				),
			)
		);

		return sprintf(
			'<li class="dsm-mega-menu-item-root %5$s">
				<a class="dsm-submenu-link" href="%2$s">%1$s %4$s</a>
				%3$s
			</li>',
			$menu_item['title'],
			esc_url( $menu_item['link'] ),
			'' !== $child_menu ? sprintf( '<ul class="dsm-submenu-container dsm-submenu-inner-wrapper animated"><div class="dsm-submenu-inner-container">%1$s</div></ul>', $child_menu ) : '',
			( 'link' === $this->props['dsm_content_type'] && '' === $child_menu ) || count( $childrens ) === 0 ? '' : $dropdown_icon,
			'click' === $dsm_trigger ? $dsm_dropdown_animation : ''
		);
	}

	/**
	 * Obtains the markup for wp native menu.
	 *
	 * @param int $menu_id - Menu id.
	 *
	 * @return string
	 */
	public function get_wp_menu_content( $menu_id ) {

		$required_menu = wp_get_nav_menu_items( $menu_id );
		$required_menu = $this->organize_menu_items( $required_menu );

		$rendered_menu = '';

		foreach ( $required_menu as $required_menu_item ) {

			$rendered_menu .= $this->render_native_menu_item( $required_menu_item );
		}

		return $rendered_menu;
	}

	public function get_woo_cart_count() {

		$has_woo_active    = class_exists( 'woocommerce' );
		$is_woo_cart_count = $has_woo_active && is_object( WC()->cart ) ? WC()->cart->get_cart_contents_count() : '';
		$woo_cart_count    = $has_woo_active ? $is_woo_cart_count : 0;

		return $woo_cart_count;
	}

	public function render( $attrs, $content, $render_slug ) {

		global $dsm_dropdown_position, $dsm_layout, $dsm_dropdown_animation, $dsm_trigger;

		$dsm_badge_text_color_last_edited              = $this->props['dsm_badge_text_color_last_edited'];
		$dsm_badge_text_color_responsive_active        = et_pb_get_responsive_status( $dsm_badge_text_color_last_edited );
		$dsm_badge_text_bg_color_last_edited           = $this->props['dsm_badge_text_bg_color_last_edited'];
		$dsm_badge_text_bg_color_responsive_active     = et_pb_get_responsive_status( $dsm_badge_text_bg_color_last_edited );
		$dsm_badge_margin_last_edited                  = $this->props['dsm_badge_margin_last_edited'];
		$dsm_badge_margin_responsive_active            = et_pb_get_responsive_status( $dsm_badge_margin_last_edited );
		$dsm_badge_padding_last_edited                 = $this->props['dsm_badge_padding_last_edited'];
		$dsm_badge_padding_responsive_active           = et_pb_get_responsive_status( $dsm_badge_padding_last_edited );
		$dsm_dropdown_bg_color_last_edited             = $this->props['dsm_dropdown_bg_color_last_edited'];
		$dsm_dropdown_bg_color_responsive_active       = et_pb_get_responsive_status( $dsm_dropdown_bg_color_last_edited );
		$dsm_dropdown_margin_last_edited               = $this->props['dsm_dropdown_margin_last_edited'];
		$dsm_dropdown_margin_responsive_active         = et_pb_get_responsive_status( $dsm_dropdown_margin_last_edited );
		$dsm_dropdown_padding_last_edited              = $this->props['dsm_dropdown_padding_last_edited'];
		$dsm_dropdown_padding_responsive_active        = et_pb_get_responsive_status( $dsm_dropdown_padding_last_edited );
		$dsm_dropdown_height_last_edited               = $this->props['dsm_dropdown_height_last_edited'];
		$dsm_dropdown_height_responsive_active         = et_pb_get_responsive_status( $dsm_dropdown_height_last_edited );
		$dsm_dropdown_icon_color_last_edited           = $this->props['dsm_dropdown_icon_color_last_edited'];
		$dsm_dropdown_icon_color_responsive_active     = et_pb_get_responsive_status( $dsm_dropdown_icon_color_last_edited );
		$dsm_dropdown_icon_font_size_last_edited       = $this->props['dsm_dropdown_icon_font_size_last_edited'];
		$dsm_dropdown_icon_font_size_responsive_active = et_pb_get_responsive_status( $dsm_dropdown_icon_font_size_last_edited );
		$dsm_dropdown_width_last_edited                = $this->props['dsm_dropdown_width_last_edited'];
		$dsm_dropdown_width_responsive_active          = et_pb_get_responsive_status( $dsm_dropdown_width_last_edited );
		$dsm_dropdown_gap_last_edited                  = $this->props['dsm_dropdown_gap_last_edited'];
		$dsm_dropdown_gap_responsive_active            = et_pb_get_responsive_status( $dsm_dropdown_gap_last_edited );
		$dsm_custom_width_last_edited                  = $this->props['dsm_custom_width_last_edited'];
		$dsm_custom_width_responsive_active            = et_pb_get_responsive_status( $dsm_custom_width_last_edited );
		$dsm_image_width_last_edited                   = $this->props['dsm_image_width_last_edited'];
		$dsm_image_width_responsive_active             = et_pb_get_responsive_status( $dsm_image_width_last_edited );
		$dsm_icon_font_size_last_edited                = $this->props['dsm_icon_font_size_last_edited'];
		$dsm_icon_font_size_responsive_active          = et_pb_get_responsive_status( $dsm_icon_font_size_last_edited );
		$dsm_icon_color_last_edited                    = $this->props['dsm_icon_color_last_edited'];
		$dsm_icon_color_responsive_active              = et_pb_get_responsive_status( $dsm_icon_color_last_edited );
		$dsm_image_icon_bg_color_last_edited           = $this->props['dsm_image_icon_bg_color_last_edited'];
		$dsm_image_icon_bg_color_responsive_active     = et_pb_get_responsive_status( $dsm_image_icon_bg_color_last_edited );
		$dsm_image_icon_margin_last_edited             = $this->props['dsm_image_icon_margin_last_edited'];
		$dsm_image_icon_margin_responsive_active       = et_pb_get_responsive_status( $dsm_image_icon_margin_last_edited );
		$dsm_image_icon_padding_last_edited            = $this->props['dsm_image_icon_padding_last_edited'];
		$dsm_image_icon_padding_responsive_active      = et_pb_get_responsive_status( $dsm_image_icon_padding_last_edited );
		$dsm_submenu_color_last_edited                 = $this->props['dsm_submenu_color_last_edited'];
		$dsm_submenu_color_responsive_active           = et_pb_get_responsive_status( $dsm_submenu_color_last_edited );
		$dsm_submenu_bg_color_last_edited              = $this->props['dsm_submenu_bg_color_last_edited'];
		$dsm_submenu_bg_color_responsive_active        = et_pb_get_responsive_status( $dsm_submenu_bg_color_last_edited );
		$dsm_submenu_margin_last_edited                = $this->props['dsm_submenu_margin_last_edited'];
		$dsm_submenu_margin_responsive_active          = et_pb_get_responsive_status( $dsm_submenu_margin_last_edited );
		$dsm_submenu_padding_last_edited               = $this->props['dsm_submenu_padding_last_edited'];
		$dsm_submenu_padding_responsive_active         = et_pb_get_responsive_status( $dsm_submenu_padding_last_edited );

		$dsm_cart_icon_color_last_edited           = $this->props['dsm_cart_icon_color_last_edited'];
		$dsm_cart_icon_color_responsive_active     = et_pb_get_responsive_status( $dsm_cart_icon_color_last_edited );
		$dsm_cart_icon_font_size_last_edited       = $this->props['dsm_cart_icon_font_size_last_edited'];
		$dsm_cart_icon_font_size_responsive_active = et_pb_get_responsive_status( $dsm_cart_icon_font_size_last_edited );

		$dsm_badge_top_pos_last_edited       = $this->props['dsm_badge_top_pos_last_edited'];
		$dsm_badge_top_pos_responsive_active = et_pb_get_responsive_status( $dsm_badge_top_pos_last_edited );

		$dsm_badge_left_pos_last_edited       = $this->props['dsm_badge_left_pos_last_edited'];
		$dsm_badge_left_pos_responsive_active = et_pb_get_responsive_status( $dsm_badge_left_pos_last_edited );

		$dsm_cart_count_bg_color_last_edited       = $this->props['dsm_cart_count_bg_color_last_edited'];
		$dsm_cart_count_bg_color_responsive_active = et_pb_get_responsive_status( $dsm_cart_count_bg_color_last_edited );
		$dsm_cart_count_color_last_edited          = $this->props['dsm_cart_count_color_last_edited'];
		$dsm_cart_count_color_responsive_active    = et_pb_get_responsive_status( $dsm_cart_count_color_last_edited );

		$dsm_cart_count_margin_last_edited        = $this->props['dsm_cart_count_margin_last_edited'];
		$dsm_cart_count_margin_responsive_active  = et_pb_get_responsive_status( $dsm_cart_count_margin_last_edited );
		$dsm_cart_count_padding_last_edited       = $this->props['dsm_cart_count_padding_last_edited'];
		$dsm_cart_count_padding_responsive_active = et_pb_get_responsive_status( $dsm_cart_count_padding_last_edited );

		$dsm_menu_item_color_last_edited          = $this->props['dsm_menu_item_color_last_edited'];
		$dsm_menu_item_color_responsive_active    = et_pb_get_responsive_status( $dsm_menu_item_color_last_edited );
		$dsm_menu_item_bg_color_last_edited       = $this->props['dsm_menu_item_bg_color_last_edited'];
		$dsm_menu_item_bg_color_responsive_active = et_pb_get_responsive_status( $dsm_menu_item_bg_color_last_edited );
		$dsm_menu_item_margin_last_edited         = $this->props['dsm_menu_item_margin_last_edited'];
		$dsm_menu_item_margin_responsive_active   = et_pb_get_responsive_status( $dsm_menu_item_margin_last_edited );
		$dsm_menu_item_padding_last_edited        = $this->props['dsm_menu_item_padding_last_edited'];
		$dsm_menu_item_padding_responsive_active  = et_pb_get_responsive_status( $dsm_menu_item_padding_last_edited );

		$dsm_arrow_color_last_edited       = $this->props['dsm_arrow_color_last_edited'];
		$dsm_arrow_color_responsive_active = et_pb_get_responsive_status( $dsm_arrow_color_last_edited );

		$dsm_menu_item_color_hover     = $this->get_hover_value( 'dsm_menu_item_color' );
		$dsm_menu_item_bg_color_hover  = $this->get_hover_value( 'dsm_menu_item_bg_color' );
		$dsm_badge_text_color_hover    = $this->get_hover_value( 'dsm_badge_text_color' );
		$dsm_badge_text_bg_color_hover = $this->get_hover_value( 'dsm_badge_text_bg_color' );
		$dsm_icon_color_hover          = $this->get_hover_value( 'dsm_icon_color' );
		$dsm_image_icon_bg_color_hover = $this->get_hover_value( 'dsm_image_icon_bg_color' );
		$dsm_dropdown_icon_color_hover = $this->get_hover_value( 'dsm_dropdown_icon_color' );

		$multi_view = et_pb_multi_view_options( $this );

		if ( $dsm_menu_item_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link:hover .dsm-menu-text',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_menu_item_color_hover ),
				)
			);
		}

		if ( $dsm_menu_item_bg_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link:hover',
					'declaration' => sprintf( 'background: %1$s !important;', $dsm_menu_item_bg_color_hover ),
				)
			);
		}

		if ( $dsm_badge_text_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item  .dsm-mega-menu-link:hover .dsm-badge-text',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_badge_text_color_hover ),
				)
			);
		}

		if ( $dsm_badge_text_bg_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item  .dsm-mega-menu-link:hover .dsm-badge-text',
					'declaration' => sprintf( 'background: %1$s !important;', $dsm_badge_text_bg_color_hover ),
				)
			);
		}

		if ( $dsm_icon_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item  .dsm-mega-menu-link:hover .dsm_icon',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_icon_color_hover ),
				)
			);
		}

		if ( $dsm_dropdown_icon_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-mega-menu-container li a:hover .dsm_dropdown_close_icon, %%order_class%% .dsm-mega-menu-container li a:hover .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_dropdown_icon_color_hover ),
				)
			);
		}

		if ( $dsm_icon_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item   .dsm-mega-menu-link:hover .dsm_icon',
					'declaration' => sprintf( 'color: %1$s !important;', $dsm_icon_color_hover ),
				)
			);
		}

		if ( $dsm_image_icon_bg_color_hover ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link:hover .dsm_icon',
					'declaration' => sprintf( 'background: %1$s !important;', $dsm_image_icon_bg_color_hover ),
				)
			);
		}

		if ( '' === $this->props['border_style_all'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm-content-timeline-content-wrapper',
					'declaration' => 'border-style: solid;',
				)
			);
		}

		if ( 'horizontal' === $dsm_layout ) {

			if ( 'container' === $this->props['dsm_width'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%%.dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container',
						'declaration' => 'width: 100%;left:0px;position: absolute !important;',
					)
				);

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item',
						'declaration' => 'position: initial !important;',
					)
				);
			}

			if ( 'fullwidth' === $this->props['dsm_width'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%%.dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container',
						'declaration' => 'position: fixed; width: 100%;left:0px;top:auto;',
					)
				);
			}

			if ( 'custom_width' === $this->props['dsm_width'] ) {

				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-submenu-container',
						'declaration' => 'position: absolute !important; left: auto !important;',
					)
				);

				if ( $this->props['dsm_custom_width'] ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-submenu-container',
							'declaration' => sprintf( 'width : %1$s !important;', $this->props['dsm_custom_width'] ),
						)
					);
				}

				if ( $dsm_custom_width_responsive_active ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-submenu-container',
							'declaration' => sprintf( 'width : %1$s !important;', $this->props['dsm_custom_width_tablet'] ),
							'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
						)
					);
				}

				if ( $dsm_custom_width_responsive_active ) {
					ET_Builder_Element::set_style(
						$render_slug,
						array(
							'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-submenu-container',
							'declaration' => sprintf( 'width : %1$s !important;', $this->props['dsm_custom_width_phone'] ),
							'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
						)
					);
				}
			}
		}

		if ( 'vertical' === $dsm_layout ) {

			if ( $this->props['dsm_dropdown_width'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%% .dsm-submenu-container',
						'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_dropdown_width'] ),
					)
				);
			}

			if ( $dsm_dropdown_width_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%% .dsm-submenu-container',
						'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_dropdown_width_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_dropdown_width_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%% .dsm-submenu-container',
						'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_dropdown_width_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}

			if ( $this->props['dsm_dropdown_gap'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-submenu-container',
						'declaration' => sprintf( 'margin-left : %1$s;', $this->props['dsm_dropdown_gap'] ),
					)
				);
			}

			if ( $dsm_dropdown_gap_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-submenu-container',
						'declaration' => sprintf( 'margin-left : %1$s;', $this->props['dsm_dropdown_gap_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_dropdown_gap_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-submenu-container',
						'declaration' => sprintf( 'margin-left : %1$s;', $this->props['dsm_dropdown_gap_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}
		}

		if ( $this->props['dsm_icon_font_size'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_icon_font_size'] ),
				)
			);
		}

		if ( $dsm_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_icon_font_size_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_icon_font_size_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_image_width'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image',
					'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_image_width'] ),
				)
			);
		}

		if ( $dsm_image_width_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image',
					'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_image_width_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_image_width_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image',
					'declaration' => sprintf( 'width : %1$s;', $this->props['dsm_image_width_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_icon_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-mega-menu-link .dsm_icon',
					'declaration' => sprintf( 'color : %1$s !important;', $this->props['dsm_icon_color'] ),
				)
			);
		}

		if ( $dsm_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-mega-menu-link .dsm_icon',
					'declaration' => sprintf( 'color : %1$s !important;', $this->props['dsm_icon_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-mega-menu-link .dsm_icon',
					'declaration' => sprintf( 'color : %1$s !important;', $this->props['dsm_icon_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_image_icon_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_image_icon_bg_color'] ),
				)
			);
		}

		if ( $dsm_image_icon_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_image_icon_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_image_icon_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_image_icon_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_margin'], $margin, $important ),
			)
		);

		if ( $dsm_image_icon_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_image_icon_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_padding'], $padding, $important ),
			)
		);

		if ( $dsm_image_icon_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_image_icon_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm-image, .dsm-mega-menu-container .dsm-root-menu %%order_class%% .dsm-menu-text-wrapper .dsm_icon',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_image_icon_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$this->generate_styles(
			array(
				'utility_arg'    => 'icon_font_family',
				'render_slug'    => $render_slug,
				'base_attr_name' => 'font_icon',
				'selector'       => '%%order_class%% .dsm_icon',
				'important'      => true,
				'processor'      => array(
					'ET_Builder_Module_Helper_Style_Processor',
					'process_extended_icon',
				),
			)
		);

		$this->generate_styles(
			array(
				'utility_arg'    => 'icon_font_family',
				'render_slug'    => $render_slug,
				'base_attr_name' => 'dsm_dropdown_open_font_icon',
				'selector'       => '%%order_class%% .dsm_dropdown_open_icon',
				'important'      => true,
				'processor'      => array(
					'ET_Builder_Module_Helper_Style_Processor',
					'process_extended_icon',
				),
			)
		);

		$this->generate_styles(
			array(
				'utility_arg'    => 'icon_font_family',
				'render_slug'    => $render_slug,
				'base_attr_name' => 'dsm_dropdown_close_font_icon',
				'selector'       => '%%order_class%% .dsm_dropdown_close_icon, %%order_class%% .dsm_dropdown_icon',
				'important'      => true,
				'processor'      => array(
					'ET_Builder_Module_Helper_Style_Processor',
					'process_extended_icon',
				),
			)
		);

		$this->generate_styles(
			array(
				'utility_arg'    => 'icon_font_family',
				'render_slug'    => $render_slug,
				'base_attr_name' => 'dsm_cart_font_icon',
				'selector'       => '%%order_class%% .dsm_cart_icon',
				'important'      => true,
				'processor'      => array(
					'ET_Builder_Module_Helper_Style_Processor',
					'process_extended_icon',
				),
			)
		);

		$icon = $multi_view->render_element(
			array(
				'tag'     => 'span',
				'content' => '{{font_icon}}',
				'attrs'   => array(
					'class' => 'dsm_icon',
				),
			)
		);

		$dropdown_open_icon = $multi_view->render_element(
			array(
				'tag'     => 'span',
				'content' => '{{dsm_dropdown_open_font_icon}}',
				'attrs'   => array(
					'class' => 'dsm_dropdown_open_icon',
				),
			)
		);

		$dropdown_close_icon = $multi_view->render_element(
			array(
				'tag'     => 'span',
				'content' => '{{dsm_dropdown_close_font_icon}}',
				'attrs'   => array(
					'class' => 'dsm_dropdown_close_icon',
				),
			)
		);

		$cart_icon = $multi_view->render_element(
			array(
				'tag'     => 'span',
				'content' => '{{dsm_cart_font_icon}}',
				'attrs'   => array(
					'class' => 'dsm_cart_icon',
				),
			)
		);

		if ( $this->props['dsm_badge_text_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_badge_text_color'] ),
				)
			);
		}

		if ( $dsm_badge_text_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_badge_text_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_badge_text_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_badge_text_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_badge_text_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_badge_text_bg_color'] ),
				)
			);
		}

		if ( $dsm_badge_text_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_badge_text_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_badge_text_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_badge_text_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_margin'], $margin, $important ),
			)
		);

		if ( $dsm_badge_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_badge_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_padding'], $padding, $important ),
			)
		);

		if ( $dsm_badge_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_badge_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_badge_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( 'absolute' === $this->props['dsm_badge_position'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => 'position: relative;',
				)
			);

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
					'declaration' => 'position: absolute;',
				)
			);

			if ( $this->props['dsm_badge_top_pos'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'top : %1$s;', $this->props['dsm_badge_top_pos'] ),
					)
				);
			}

			if ( $dsm_badge_top_pos_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'top : %1$s;', $this->props['dsm_badge_top_pos_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_badge_top_pos_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'top : %1$s;', $this->props['dsm_badge_top_pos_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}

			if ( $this->props['dsm_badge_left_pos'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'left : %1$s;', $this->props['dsm_badge_left_pos'] ),
					)
				);
			}

			if ( $dsm_badge_left_pos_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'left : %1$s;', $this->props['dsm_badge_left_pos_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_badge_left_pos_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text-wrapper .dsm-badge-text',
						'declaration' => sprintf( 'left : %1$s;', $this->props['dsm_badge_left_pos_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}
		}

		if ( $this->props['dsm_dropdown_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item  .dsm-submenu-container .dsm-submenu-inner-container',
					'declaration' => sprintf( 'background : %1$s !important;', $this->props['dsm_dropdown_bg_color'] ),
				)
			);
		}

		if ( $dsm_dropdown_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-submenu-container .dsm-submenu-inner-container',
					'declaration' => sprintf( 'background : %1$s !important;', $this->props['dsm_dropdown_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_dropdown_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-submenu-container .dsm-submenu-inner-container',
					'declaration' => sprintf( 'background : %1$s !important;', $this->props['dsm_dropdown_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_dropdown_icon_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm_dropdown_close_icon, %%order_class%%  .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_dropdown_icon_color'] ),
				)
			);
		}

		if ( $dsm_dropdown_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm_dropdown_close_icon, %%order_class%%  .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_dropdown_icon_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_dropdown_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm_dropdown_close_icon, %%order_class%%  .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_dropdown_icon_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_dropdown_icon_font_size'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm_dropdown_close_icon, %%order_class%%  .dsm_dropdown_open_icon,',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_dropdown_icon_font_size'] ),
				)
			);
		}

		if ( $dsm_dropdown_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm_dropdown_close_icon, %%order_class%%  .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_dropdown_icon_font_size_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_dropdown_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '%%order_class%% .dsm_dropdown_close_icon, %%order_class%%  .dsm_dropdown_open_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_dropdown_icon_font_size_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( 'on' === $this->props['dsm_use_custom_height'] ) {

			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%%.dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container .dsm-submenu-inner-container',
					'declaration' => 'overflow-y : scroll !important;',
				)
			);

			if ( $this->props['dsm_dropdown_height'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%%.dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container .dsm-submenu-inner-container',
						'declaration' => sprintf( 'height : %1$s;', $this->props['dsm_dropdown_height'] ),
					)
				);
			}

			if ( $dsm_dropdown_height_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%%.dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container .dsm-submenu-inner-container',
						'declaration' => sprintf( 'height : %1$s;', $this->props['dsm_dropdown_height_tablet'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
					)
				);
			}

			if ( $dsm_dropdown_height_responsive_active ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container:not(.mobile-menu) .dsm-root-menu %%order_class%%.dsm-mega-menu-item:not(.dsm-native-menu) .dsm-submenu-container .dsm-submenu-inner-container',
						'declaration' => sprintf( 'height : %1$s;', $this->props['dsm_dropdown_height_phone'] ),
						'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
					)
				);
			}
		}

		// menu item styling work

		$margin    = 'margin';
		$padding   = 'padding';
		$important = true;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_padding'], $padding, $important ),
			)
		);

		if ( $dsm_menu_item_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_menu_item_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_margin'], $margin, $important ),
			)
		);

		if ( $dsm_menu_item_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_menu_item_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_menu_item_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_menu_item_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text',
					'declaration' => sprintf( 'color : %1$s !important;', $this->props['dsm_menu_item_color'] ),
				)
			);
		}

		if ( $dsm_menu_item_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text',
					'declaration' => sprintf( 'color : %1$s !important;', $this->props['dsm_menu_item_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_menu_item_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-menu-text',
					'declaration' => sprintf( 'color : %1$s !important;', $this->props['dsm_menu_item_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_menu_item_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => sprintf( 'background-color : %1$s !important;', $this->props['dsm_menu_item_bg_color'] ),
				)
			);
		}

		if ( $dsm_menu_item_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => sprintf( 'background-color : %1$s !important;', $this->props['dsm_menu_item_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_menu_item_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link',
					'declaration' => sprintf( 'background-color : %1$s !important;', $this->props['dsm_menu_item_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		// submenu styling work

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '.dsm-mega-menu-container .dsm-root-menu  %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_margin'], $margin, $important ),
			)
		);

		if ( $dsm_submenu_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu  %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_submenu_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu  %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '.dsm-mega-menu-container .dsm-root-menu  %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_padding'], $padding, $important ),
			)
		);

		if ( $dsm_submenu_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu  %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_submenu_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu  %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_submenu_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_submenu_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container a',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_submenu_color'] ),
				)
			);
		}

		if ( $dsm_submenu_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container a',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_submenu_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_submenu_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container a',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_submenu_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_submenu_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_submenu_bg_color'] ),
				)
			);
		}

		if ( $dsm_submenu_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_submenu_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_submenu_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item.dsm-native-menu .dsm-submenu-container li',
					'declaration' => sprintf( 'background : %1$s;', $this->props['dsm_submenu_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		// cart icon styling

		if ( $this->props['dsm_cart_icon_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'color : %1$s !important;', $this->props['dsm_cart_icon_color'] ),
				)
			);
		}

		if ( $dsm_cart_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_cart_icon_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_icon_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_cart_icon_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_cart_icon_font_size'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'font-size : %1$s !important;', $this->props['dsm_cart_icon_font_size'] ),
				)
			);
		}

		if ( $dsm_cart_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_cart_icon_font_size_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_icon_font_size_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-link .dsm-menu-text-wrapper .dsm_cart_icon',
					'declaration' => sprintf( 'font-size : %1$s;', $this->props['dsm_cart_icon_font_size_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$margin    = 'margin';
		$padding   = 'padding';
		$important = false;

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_margin'], $margin, $important ),
			)
		);

		if ( $dsm_cart_count_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_margin_tablet'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_count_margin_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_margin_phone'], $margin, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		ET_Builder_Element::set_style(
			$render_slug,
			array(
				'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
				'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_padding'], $padding, $important ),
			)
		);

		if ( $dsm_cart_count_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_padding_tablet'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_count_padding_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => et_builder_get_element_style_css( $this->props['dsm_cart_count_padding_phone'], $padding, $important ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_cart_count_bg_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_cart_count_bg_color'] ),
				)
			);
		}

		if ( $dsm_cart_count_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_cart_count_bg_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_count_bg_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'background-color : %1$s;', $this->props['dsm_cart_count_bg_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		if ( $this->props['dsm_cart_count_color'] ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_cart_count_color'] ),
				)
			);
		}

		if ( $dsm_cart_count_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_cart_count_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_cart_count_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-mega-menu-woo-cart-count',
					'declaration' => sprintf( 'color : %1$s;', $this->props['dsm_cart_count_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		// arrow color styling

		if ( $this->props['dsm_arrow_color'] ) {
				ET_Builder_Element::set_style(
					$render_slug,
					array(
						'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-submenu-container:before',
						'declaration' => sprintf( 'background : %1$s !important;', $this->props['dsm_arrow_color'] ),
					)
				);
		}

		if ( $dsm_arrow_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-submenu-container:before',
					'declaration' => sprintf( 'background : %1$s !important;', $this->props['dsm_arrow_color_tablet'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_980' ),
				)
			);
		}

		if ( $dsm_arrow_color_responsive_active ) {
			ET_Builder_Element::set_style(
				$render_slug,
				array(
					'selector'    => '.dsm-mega-menu-container .dsm-root-menu %%order_class%%.dsm-mega-menu-item .dsm-submenu-container:before',
					'declaration' => sprintf( 'background : %1$s !important;', $this->props['dsm_arrow_color_phone'] ),
					'media_query' => ET_Builder_Element::get_media_query( 'max_width_767' ),
				)
			);
		}

		$order_class = self::get_module_order_class( $render_slug );
		$menu_type   = $this->props['dsm_content_type'];

		$menu_content = '';

		switch ( $menu_type ) {
			case 'native_menu':
				$menu_content = 'none' === $this->props['dsm_native_menu'] ? '' : $this->get_wp_menu_content( $this->props['dsm_native_menu'] );
				break;
			case 'divi_layout':
				$menu_content = 'select' === $this->props['dsm_library_layout'] ? '' : do_shortcode( sprintf( '[et_pb_section global_module="%1$s"][/et_pb_section]', $this->props['dsm_library_layout'] ) );
		}

		$submenu = sprintf(
			'
			<ul class="dsm-submenu-container animated">
				<div class="dsm-submenu-inner-container">%1$s</div>
			</ul>
			',
			$menu_content
		);

		if ( '' === $menu_content ) {
			$submenu = '';
		}

		$woo_cart_count_markup = sprintf( '<span class="dsm-mega-menu-woo-cart-count">%1$s</span>', $this->get_woo_cart_count() );

		$menu_title = sprintf(
			'<div class="dsm-dropdown-icon-wrapper">
				%7$s
				%11$s
			</div>
			<div class="dsm-menu-text-wrapper">
			   %2$s
			   %5$s 
			   %1$s
			   %3$s
			   %6$s
			   %10$s
			   %9$s
			   %4$s
			</div>
			<div class="dsm-dropdown-icon-wrapper">
				%8$s
			  	%12$s
			</div>
			',
			'' !== trim( $this->props['dsm_menu_label'] ) ? sprintf( '<span class="dsm-menu-text" itemprop="name">%1$s</span>', $this->props['dsm_menu_label'] ) : '',
			'on' === $this->props['dsm_use_image_icon'] && 'on' === $this->props['dsm_use_icon'] && 'left' === $this->props['dsm_image_icon_alignment'] ? $icon : '',
			'on' === $this->props['dsm_use_image_icon'] && 'on' === $this->props['dsm_use_icon'] && 'right' === $this->props['dsm_image_icon_alignment'] ? $icon : '',
			'' !== trim( $this->props['dsm_badge_text'] ) ? sprintf( '<span class="dsm-badge-text">%1$s</span>', $this->props['dsm_badge_text'] ) : '',
			'on' === $this->props['dsm_use_image_icon'] && 'off' === $this->props['dsm_use_icon'] && 'left' === $this->props['dsm_image_icon_alignment'] ? sprintf( '<div class="dsm-image"><img src="%1$s"/></div>', $this->props['dsm_image'] ) : '',
			'on' === $this->props['dsm_use_image_icon'] && 'off' === $this->props['dsm_use_icon'] && 'right' === $this->props['dsm_image_icon_alignment'] ? sprintf( '<div class="dsm-image"><img src="%1$s"/></div>', $this->props['dsm_image'] ) : '',
			'left' === $this->props['dsm_dropdown_icon_position'] && 'link' !== $this->props['dsm_content_type'] ? $dropdown_close_icon : '',
			'right' === $this->props['dsm_dropdown_icon_position'] && 'link' !== $this->props['dsm_content_type'] ? $dropdown_close_icon : '',
			'on' === $this->props['dsm_show_woo_cart_count'] ? $woo_cart_count_markup : '',
			'on' === $this->props['dsm_show_woo_cart_count'] ? $cart_icon : '',
			'left' === $this->props['dsm_dropdown_icon_position'] && 'link' !== $this->props['dsm_content_type'] ? $dropdown_open_icon : '',
			'right' === $this->props['dsm_dropdown_icon_position'] && 'link' !== $this->props['dsm_content_type'] ? $dropdown_open_icon : ''
		);

		$output = sprintf(
			'<li class="dsm-mega-menu-item dsm-mega-menu-item-root %7$s %4$s %1$s">
			    <a class="dsm-mega-menu-link" href="%5$s" %6$s itemprop="url">
				   %3$s
				</a>
				%2$s
			 </li>
			',
			$order_class,
			'link' === $menu_type ? '' : $submenu,
			$menu_title,
			'native_menu' === $this->props['dsm_content_type'] ? 'dsm-native-menu' : '',
			'' !== $this->props['dsm_link'] ? $this->props['dsm_link'] : '#',
			'' !== $this->props['dsm_link'] && 'new_page' === $this->props['dsm_link_target'] ? 'target="_blank"' : '',
			'click' === $dsm_trigger ? $dsm_dropdown_animation : ''
		);

		add_filter( 'et_global_assets_list', array( $this, 'dsm_load_required_divi_assets' ), 10, 3 );
		add_filter( 'et_late_global_assets_list', array( $this, 'dsm_load_required_divi_assets' ), 10, 3 );

		return $output;
	}

	/**
	 * Filter multi view value.
	 *
	 * @since 3.27.1
	 *
	 * @see ET_Builder_Module_Helper_MultiViewOptions::filter_value
	 *
	 * @param mixed                                     $raw_value Props raw value.
	 * @param array                                     $args {
	 *                                         Context data.
	 *
	 *     @type string $context      Context param: content, attrs, visibility, classes.
	 *     @type string $name         Module options props name.
	 *     @type string $mode         Current data mode: desktop, hover, tablet, phone.
	 *     @type string $attr_key     Attribute key for attrs context data. Example: src, class, etc.
	 *     @type string $attr_sub_key Attribute sub key that availabe when passing attrs value as array such as styes. Example: padding-top, margin-botton, etc.
	 * }
	 * @param ET_Builder_Module_Helper_MultiViewOptions $multi_view Multiview object instance.
	 *
	 * @return mixed
	 */
	public function multi_view_filter_value( $raw_value, $args, $multi_view ) {
		$name = isset( $args['name'] ) ? $args['name'] : '';
		$mode = isset( $args['mode'] ) ? $args['mode'] : '';

		if ( $raw_value && 'font_icon' === $name ) {
			return et_pb_get_extended_font_icon_value( $raw_value, true );
		}

		if ( $raw_value && 'dsm_dropdown_open_font_icon' === $name ) {
			return et_pb_get_extended_font_icon_value( $raw_value, true );
		}

		if ( $raw_value && 'dsm_dropdown_close_font_icon' === $name ) {
			return et_pb_get_extended_font_icon_value( $raw_value, true );
		}

		if ( $raw_value && 'dsm_cart_font_icon' === $name ) {
			return et_pb_get_extended_font_icon_value( $raw_value, true );
		}

		if ( $raw_value && 'dsm_parent_dropdown_open_font_icon' === $name ) {
			return et_pb_get_extended_font_icon_value( $raw_value, true );
		}

		$fields_need_escape = array(
			'button_text',
		);

		if ( $raw_value && in_array( $name, $fields_need_escape, true ) ) {
			return $this->_esc_attr( $multi_view->get_name_by_mode( $name, $mode ), 'none', $raw_value );
		}

		return $raw_value;
	}

	protected function _render_module_wrapper( $output = '', $render_slug = '' ) {
		return $output;
	}

	/**
	 * Force load global styles.
	 *
	 * @param array $assets_list Current global assets on the list.
	 *
	 * @return array
	 */
	public function dsm_load_required_divi_assets( $assets_list, $assets_args, $instance ) {
		$assets_prefix  = et_get_dynamic_assets_path();
		$all_shortcodes = $instance->get_saved_page_shortcodes();
		if ( ! isset( $assets_list['et_icons_all'] ) ) {
			$assets_list['et_icons_all'] = array(
				'css' => "{$assets_prefix}/css/icons_all.css",
			);
		}

		if ( ! isset( $assets_list['et_icons_fa'] ) ) {
			$assets_list['et_icons_fa'] = array(
				'css' => "{$assets_prefix}/css/icons_fa_all.css",
			);
		}

		return $assets_list;
	}
}

new DSM_Mega_Menu_Child();
