<?php
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'wacu_month_dropdown' ) ):
	function wacu_month_dropdown( $args = array() ) {
		$html = '';

		$inline_css = ( isset( $args['inline_css'] ) ) ? "style='{$args['inline_css']}'" : '';
		$selected   = ( isset( $args['selected'] ) ) ? $args['selected'] : '';
		$name       = ( isset( $args['name'] ) ) ? "name='{$args['name']}'" : '';

		$months = array(
			'jan' => esc_html__( 'January', 'wp-any-contact-us' ),
			'feb' => esc_html__( 'February', 'wp-any-contact-us' ),
			'mar' => esc_html__( 'March', 'wp-any-contact-us' ),
			'apr' => esc_html__( 'April', 'wp-any-contact-us' ),
			'may' => esc_html__( 'May', 'wp-any-contact-us' ),
			'jun' => esc_html__( 'June', 'wp-any-contact-us' ),
			'jul' => esc_html__( 'July', 'wp-any-contact-us' ),
			'aug' => esc_html__( 'August', 'wp-any-contact-us' ),
			'sep' => esc_html__( 'September', 'wp-any-contact-us' ),
			'oct' => esc_html__( 'October', 'wp-any-contact-us' ),
			'nov' => esc_html__( 'November', 'wp-any-contact-us' ),
			'dec' => esc_html__( 'December', 'wp-any-contact-us' ),
		);

		/**
		 * Filter months name.
		 *
		 * @since  2.1.1
		 */
		$months = apply_filters( 'wacu_months_name', $months );

		$html .= "<select $name $inline_css >";

		foreach ( $months as $month ) {
			if ( $month == $selected ):
				$html .= "<option value='{$month}' selected>{$month}</option>";
			else:
				$html .= "<option value='{$month}'>{$month}</option>";
			endif;
		}

		$html .= "</select>";

		echo $html;
	}

endif;

if ( ! function_exists( 'wacu_countries_dropdown' ) ):
	function wacu_countries_dropdown( $args = array() ) {
		$html       = '';
		$name       = ( $args['name'] ) ? 'name="' . $args['name'] . '" ' : '';
		$inline_css = ( isset( $args['inline_css'] ) ) ? "style='{$args['inline_css']}'" : '';

		$countries = apply_filters( 'wacu_countries', array(
			'Afghanistan'                                => esc_html__( 'Afghanistan', 'wp-any-contact-us' ),
			'Åland Islands'                              => esc_html__( 'Åland Islands', 'wp-any-contact-us' ),
			'Albania'                                    => esc_html__( 'Albania', 'wp-any-contact-us' ),
			'Algeria'                                    => esc_html__( 'Algeria', 'wp-any-contact-us' ),
			'Algeria'                                    => esc_html__( 'Algeria Samoa', 'wp-any-contact-us' ),
			'Andorra'                                    => esc_html__( 'Andorra', 'wp-any-contact-us' ),
			'Angola'                                     => esc_html__( 'Angola', 'wp-any-contact-us' ),
			'Anguilla'                                   => esc_html__( 'Anguilla', 'wp-any-contact-us' ),
			'Antarctica'                                 => esc_html__( 'Antarctica', 'wp-any-contact-us' ),
			'Antigua and Barbuda'                        => esc_html__( 'Antigua and Barbuda', 'wp-any-contact-us' ),
			'Argentina'                                  => esc_html__( 'Argentina', 'wp-any-contact-us' ),
			'Armenia'                                    => esc_html__( 'Armenia', 'wp-any-contact-us' ),
			'Aruba'                                      => esc_html__( 'Aruba', 'wp-any-contact-us' ),
			'Australia'                                  => esc_html__( 'Australia', 'wp-any-contact-us' ),
			'Austria'                                    => esc_html__( 'Austria', 'wp-any-contact-us' ),
			'Azerbaijan'                                 => esc_html__( 'Azerbaijan', 'wp-any-contact-us' ),
			'Bahamas'                                    => esc_html__( 'Bahamas', 'wp-any-contact-us' ),
			'Bahrain'                                    => esc_html__( 'Bahrain', 'wp-any-contact-us' ),
			'Bangladesh'                                 => esc_html__( 'Bangladesh', 'wp-any-contact-us' ),
			'Barbados'                                   => esc_html__( 'Barbados', 'wp-any-contact-us' ),
			'Belarus'                                    => esc_html__( 'Belarus', 'wp-any-contact-us' ),
			'Belgium'                                    => esc_html__( 'Belgium', 'wp-any-contact-us' ),
			'Belau'                                      => esc_html__( 'Belau', 'wp-any-contact-us' ),
			'Belize'                                     => esc_html__( 'Belize', 'wp-any-contact-us' ),
			'Benin'                                      => esc_html__( 'Benin', 'wp-any-contact-us' ),
			'Bermuda'                                    => esc_html__( 'Bermuda', 'wp-any-contact-us' ),
			'Bhutan'                                     => esc_html__( 'Bhutan', 'wp-any-contact-us' ),
			'Bolivia'                                    => esc_html__( 'Bolivia', 'wp-any-contact-us' ),
			'Bonaire, Saint Eustatius and Saba'          => esc_html__( 'Bonaire, Saint Eustatius and Saba', 'wp-any-contact-us' ),
			'Bosnia and Herzegovina'                     => esc_html__( 'Bosnia and Herzegovina', 'wp-any-contact-us' ),
			'Botswana'                                   => esc_html__( 'Botswana', 'wp-any-contact-us' ),
			'Bouvet Island'                              => esc_html__( 'Bouvet Island', 'wp-any-contact-us' ),
			'Brazil'                                     => esc_html__( 'Brazil', 'wp-any-contact-us' ),
			'British Indian Ocean Territory'             => esc_html__( 'British Indian Ocean Territory', 'wp-any-contact-us' ),
			'Brunei'                                     => esc_html__( 'Brunei', 'wp-any-contact-us' ),
			'Bulgaria'                                   => esc_html__( 'Bulgaria', 'wp-any-contact-us' ),
			'Burkina Faso'                               => esc_html__( 'Burkina Faso', 'wp-any-contact-us' ),
			'Burundi'                                    => esc_html__( 'Burundi', 'wp-any-contact-us' ),
			'Cambodia'                                   => esc_html__( 'Cambodia', 'wp-any-contact-us' ),
			'Cameroon'                                   => esc_html__( 'Cameroon', 'wp-any-contact-us' ),
			'Canada'                                     => esc_html__( 'Canada', 'wp-any-contact-us' ),
			'Cape Verde'                                 => esc_html__( 'Cape Verde', 'wp-any-contact-us' ),
			'Cayman Islands'                             => esc_html__( 'Cayman Islands', 'wp-any-contact-us' ),
			'Central African Republic'                   => esc_html__( 'Central African Republic', 'wp-any-contact-us' ),
			'Chad'                                       => esc_html__( 'Chad', 'wp-any-contact-us' ),
			'Chile'                                      => esc_html__( 'Chile', 'wp-any-contact-us' ),
			'China'                                      => esc_html__( 'China', 'wp-any-contact-us' ),
			'Christmas Island'                           => esc_html__( 'Christmas Island', 'wp-any-contact-us' ),
			'Cocos (Keeling) Islands'                    => esc_html__( 'Cocos (Keeling) Islands', 'wp-any-contact-us' ),
			'Colombia'                                   => esc_html__( 'Colombia', 'wp-any-contact-us' ),
			'Comoros'                                    => esc_html__( 'Comoros', 'wp-any-contact-us' ),
			'Congo (Brazzaville)'                        => esc_html__( 'Congo (Brazzaville)', 'wp-any-contact-us' ),
			'Congo (Kinshasa)'                           => esc_html__( 'Congo (Kinshasa)', 'wp-any-contact-us' ),
			'Cook Islands'                               => esc_html__( 'Cook Islands', 'wp-any-contact-us' ),
			'Costa Rica'                                 => esc_html__( 'Costa Rica', 'wp-any-contact-us' ),
			'Croatia'                                    => esc_html__( 'Croatia', 'wp-any-contact-us' ),
			'Cuba'                                       => esc_html__( 'Cuba', 'wp-any-contact-us' ),
			'Cura&ccedil;ao'                             => esc_html__( 'Cura&ccedil;ao', 'wp-any-contact-us' ),
			'Cyprus'                                     => esc_html__( 'Cyprus', 'wp-any-contact-us' ),
			'Czech Republic'                             => esc_html__( 'Czech Republic', 'wp-any-contact-us' ),
			'Denmark'                                    => esc_html__( 'Denmark', 'wp-any-contact-us' ),
			'Djibouti'                                   => esc_html__( 'Djibouti', 'wp-any-contact-us' ),
			'Dominica'                                   => esc_html__( 'Dominica', 'wp-any-contact-us' ),
			'Dominican Republic'                         => esc_html__( 'Dominican Republic', 'wp-any-contact-us' ),
			'Ecuador'                                    => esc_html__( 'Ecuador', 'wp-any-contact-us' ),
			'Egypt'                                      => esc_html__( 'Egypt', 'wp-any-contact-us' ),
			'El Salvador'                                => esc_html__( 'El Salvador', 'wp-any-contact-us' ),
			'Equatorial Guinea'                          => esc_html__( 'Equatorial Guinea', 'wp-any-contact-us' ),
			'Eritrea'                                    => esc_html__( 'Eritrea', 'wp-any-contact-us' ),
			'Estonia'                                    => esc_html__( 'Estonia', 'wp-any-contact-us' ),
			'Ethiopia'                                   => esc_html__( 'Ethiopia', 'wp-any-contact-us' ),
			'Falkland Islands'                           => esc_html__( 'Falkland Islands', 'wp-any-contact-us' ),
			'Faroe Islands'                              => esc_html__( 'Faroe Islands', 'wp-any-contact-us' ),
			'Fiji'                                       => esc_html__( 'Fiji', 'wp-any-contact-us' ),
			'Finland'                                    => esc_html__( 'Finland', 'wp-any-contact-us' ),
			'France'                                     => esc_html__( 'France', 'wp-any-contact-us' ),
			'French Guiana'                              => esc_html__( 'French Guiana', 'wp-any-contact-us' ),
			'French Polynesia'                           => esc_html__( 'French Polynesia', 'wp-any-contact-us' ),
			'French Southern Territories'                => esc_html__( 'French Southern Territories', 'wp-any-contact-us' ),
			'Gabon'                                      => esc_html__( 'Gabon', 'wp-any-contact-us' ),
			'Gambia'                                     => esc_html__( 'Gambia', 'wp-any-contact-us' ),
			'Georgia'                                    => esc_html__( 'Georgia', 'wp-any-contact-us' ),
			'Germany'                                    => esc_html__( 'Germany', 'wp-any-contact-us' ),
			'Ghana'                                      => esc_html__( 'Ghana', 'wp-any-contact-us' ),
			'Gibraltar'                                  => esc_html__( 'Gibraltar', 'wp-any-contact-us' ),
			'Greece'                                     => esc_html__( 'Greece', 'wp-any-contact-us' ),
			'Greenland'                                  => esc_html__( 'Greenland', 'wp-any-contact-us' ),
			'Grenada'                                    => esc_html__( 'Grenada', 'wp-any-contact-us' ),
			'Guadeloupe'                                 => esc_html__( 'Guadeloupe', 'wp-any-contact-us' ),
			'Guam'                                       => esc_html__( 'Guam', 'wp-any-contact-us' ),
			'Guatemala'                                  => esc_html__( 'Guatemala', 'wp-any-contact-us' ),
			'Guernsey'                                   => esc_html__( 'Guernsey', 'wp-any-contact-us' ),
			'Guinea'                                     => esc_html__( 'Guinea', 'wp-any-contact-us' ),
			'Guinea-Bissau'                              => esc_html__( 'Guinea-Bissau', 'wp-any-contact-us' ),
			'Guyana'                                     => esc_html__( 'Guyana', 'wp-any-contact-us' ),
			'Haiti'                                      => esc_html__( 'Haiti', 'wp-any-contact-us' ),
			'Heard Island and McDonald Islands'          => esc_html__( 'Heard Island and McDonald Islands', 'wp-any-contact-us' ),
			'Honduras'                                   => esc_html__( 'Honduras', 'wp-any-contact-us' ),
			'Hong Kong'                                  => esc_html__( 'Hong Kong', 'wp-any-contact-us' ),
			'Hungary'                                    => esc_html__( 'Hungary', 'wp-any-contact-us' ),
			'Iceland'                                    => esc_html__( 'Iceland', 'wp-any-contact-us' ),
			'India'                                      => esc_html__( 'India', 'wp-any-contact-us' ),
			'Indonesia'                                  => esc_html__( 'Indonesia', 'wp-any-contact-us' ),
			'Iran'                                       => esc_html__( 'Iran', 'wp-any-contact-us' ),
			'Iraq'                                       => esc_html__( 'Iraq', 'wp-any-contact-us' ),
			'Ireland'                                    => esc_html__( 'Ireland', 'wp-any-contact-us' ),
			'Isle of Man'                                => esc_html__( 'Isle of Man', 'wp-any-contact-us' ),
			'Israel'                                     => esc_html__( 'Israel', 'wp-any-contact-us' ),
			'Italy'                                      => esc_html__( 'Italy', 'wp-any-contact-us' ),
			'Ivory Coast'                                => esc_html__( 'Ivory Coast', 'wp-any-contact-us' ),
			'Jamaica'                                    => esc_html__( 'Jamaica', 'wp-any-contact-us' ),
			'Japan'                                      => esc_html__( 'Japan', 'wp-any-contact-us' ),
			'Jersey'                                     => esc_html__( 'Jersey', 'wp-any-contact-us' ),
			'Jordan'                                     => esc_html__( 'Jordan', 'wp-any-contact-us' ),
			'Kazakhstan'                                 => esc_html__( 'Kazakhstan', 'wp-any-contact-us' ),
			'Kenya'                                      => esc_html__( 'Kenya', 'wp-any-contact-us' ),
			'Kiribati'                                   => esc_html__( 'Kiribati', 'wp-any-contact-us' ),
			'Kuwait'                                     => esc_html__( 'Kuwait', 'wp-any-contact-us' ),
			'Kyrgyzstan'                                 => esc_html__( 'Kyrgyzstan', 'wp-any-contact-us' ),
			'Laos'                                       => esc_html__( 'Laos', 'wp-any-contact-us' ),
			'Latvia'                                     => esc_html__( 'Latvia', 'wp-any-contact-us' ),
			'Lebanon'                                    => esc_html__( 'Lebanon', 'wp-any-contact-us' ),
			'Lesotho'                                    => esc_html__( 'Lesotho', 'wp-any-contact-us' ),
			'Liberia'                                    => esc_html__( 'Liberia', 'wp-any-contact-us' ),
			'Libya'                                      => esc_html__( 'Libya', 'wp-any-contact-us' ),
			'Liechtenstein'                              => esc_html__( 'Liechtenstein', 'wp-any-contact-us' ),
			'Lithuania'                                  => esc_html__( 'Lithuania', 'wp-any-contact-us' ),
			'Luxembourg'                                 => esc_html__( 'Luxembourg', 'wp-any-contact-us' ),
			'Macao S.A.R., China'                        => esc_html__( 'Macao S.A.R., China', 'wp-any-contact-us' ),
			'Macedonia'                                  => esc_html__( 'Macedonia', 'wp-any-contact-us' ),
			'Madagascar'                                 => esc_html__( 'Madagascar', 'wp-any-contact-us' ),
			'Malawi'                                     => esc_html__( 'Malawi', 'wp-any-contact-us' ),
			'Malaysia'                                   => esc_html__( 'Malaysia', 'wp-any-contact-us' ),
			'Maldives'                                   => esc_html__( 'Maldives', 'wp-any-contact-us' ),
			'Mali'                                       => esc_html__( 'Mali', 'wp-any-contact-us' ),
			'Malta'                                      => esc_html__( 'Malta', 'wp-any-contact-us' ),
			'Marshall Islands'                           => esc_html__( 'Marshall Islands', 'wp-any-contact-us' ),
			'Martinique'                                 => esc_html__( 'Martinique', 'wp-any-contact-us' ),
			'Mauritania'                                 => esc_html__( 'Mauritania', 'wp-any-contact-us' ),
			'Mauritius'                                  => esc_html__( 'Mauritius', 'wp-any-contact-us' ),
			'Mayotte'                                    => esc_html__( 'Mayotte', 'wp-any-contact-us' ),
			'Mexico'                                     => esc_html__( 'Mexico', 'wp-any-contact-us' ),
			'Micronesia'                                 => esc_html__( 'Micronesia', 'wp-any-contact-us' ),
			'Moldova'                                    => esc_html__( 'Moldova', 'wp-any-contact-us' ),
			'Monaco'                                     => esc_html__( 'Monaco', 'wp-any-contact-us' ),
			'Mongolia'                                   => esc_html__( 'Mongolia', 'wp-any-contact-us' ),
			'Montenegro'                                 => esc_html__( 'Montenegro', 'wp-any-contact-us' ),
			'Montserrat'                                 => esc_html__( 'Montserrat', 'wp-any-contact-us' ),
			'Morocco'                                    => esc_html__( 'Morocco', 'wp-any-contact-us' ),
			'Mozambique'                                 => esc_html__( 'Mozambique', 'wp-any-contact-us' ),
			'Myanmar'                                    => esc_html__( 'Myanmar', 'wp-any-contact-us' ),
			'Namibia'                                    => esc_html__( 'Namibia', 'wp-any-contact-us' ),
			'Nauru'                                      => esc_html__( 'Nauru', 'wp-any-contact-us' ),
			'Nepal'                                      => esc_html__( 'Nepal', 'wp-any-contact-us' ),
			'Netherlands'                                => esc_html__( 'Netherlands', 'wp-any-contact-us' ),
			'New Caledonia'                              => esc_html__( 'New Caledonia', 'wp-any-contact-us' ),
			'New Zealand'                                => esc_html__( 'New Zealand', 'wp-any-contact-us' ),
			'Nicaragua'                                  => esc_html__( 'Nicaragua', 'wp-any-contact-us' ),
			'Niger'                                      => esc_html__( 'Niger', 'wp-any-contact-us' ),
			'Nigeria'                                    => esc_html__( 'Nigeria', 'wp-any-contact-us' ),
			'Niue'                                       => esc_html__( 'Niue', 'wp-any-contact-us' ),
			'Norfolk Island'                             => esc_html__( 'Norfolk Island', 'wp-any-contact-us' ),
			'Northern Mariana Islands'                   => esc_html__( 'Northern Mariana Islands', 'wp-any-contact-us' ),
			'North Korea'                                => esc_html__( 'North Korea', 'wp-any-contact-us' ),
			'Norway'                                     => esc_html__( 'Norway', 'wp-any-contact-us' ),
			'Oman'                                       => esc_html__( 'Oman', 'wp-any-contact-us' ),
			'Pakistan'                                   => esc_html__( 'Pakistan', 'wp-any-contact-us' ),
			'Palestinian Territory'                      => esc_html__( 'Palestinian Territory', 'wp-any-contact-us' ),
			'Panama'                                     => esc_html__( 'Panama', 'wp-any-contact-us' ),
			'Papua New Guinea'                           => esc_html__( 'Papua New Guinea', 'wp-any-contact-us' ),
			'Paraguay'                                   => esc_html__( 'Paraguay', 'wp-any-contact-us' ),
			'Peru'                                       => esc_html__( 'Peru', 'wp-any-contact-us' ),
			'Philippines'                                => esc_html__( 'Philippines', 'wp-any-contact-us' ),
			'Pitcairn'                                   => esc_html__( 'Pitcairn', 'wp-any-contact-us' ),
			'Poland'                                     => esc_html__( 'Poland', 'wp-any-contact-us' ),
			'Portugal'                                   => esc_html__( 'Portugal', 'wp-any-contact-us' ),
			'Puerto Rico'                                => esc_html__( 'Puerto Rico', 'wp-any-contact-us' ),
			'Qatar'                                      => esc_html__( 'Qatar', 'wp-any-contact-us' ),
			'Reunion'                                    => esc_html__( 'Reunion', 'wp-any-contact-us' ),
			'Romania'                                    => esc_html__( 'Romania', 'wp-any-contact-us' ),
			'Russia'                                     => esc_html__( 'Russia', 'wp-any-contact-us' ),
			'Rwanda'                                     => esc_html__( 'Rwanda', 'wp-any-contact-us' ),
			'Saint Barth&eacute;lemy'                    => esc_html__( 'Saint Barth&eacute;lemy', 'wp-any-contact-us' ),
			'Saint Helena'                               => esc_html__( 'Saint Helena', 'wp-any-contact-us' ),
			'Saint Kitts and Nevis'                      => esc_html__( 'Saint Kitts and Nevis', 'wp-any-contact-us' ),
			'Saint Lucia'                                => esc_html__( 'Saint Lucia', 'wp-any-contact-us' ),
			'Saint Martin (French part)'                 => esc_html__( 'Saint Martin (French part)', 'wp-any-contact-us' ),
			'Saint Martin (Dutch part)'                  => esc_html__( 'Saint Martin (Dutch part)', 'wp-any-contact-us' ),
			'Saint Pierre and Miquelon'                  => esc_html__( 'Saint Pierre and Miquelon', 'wp-any-contact-us' ),
			'Saint Vincent and the Grenadines'           => esc_html__( 'Saint Vincent and the Grenadines', 'wp-any-contact-us' ),
			'San Marino'                                 => esc_html__( 'San Marino', 'wp-any-contact-us' ),
			'S&atilde;o Tom&eacute; and Pr&iacute;ncipe' => esc_html__( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'wp-any-contact-us' ),
			'SA'                                         => esc_html__( 'Saudi Arabia', 'wp-any-contact-us' ),
			'Senegal'                                    => esc_html__( 'Senegal', 'wp-any-contact-us' ),
			'Serbia'                                     => esc_html__( 'Serbia', 'wp-any-contact-us' ),
			'Seychelles'                                 => esc_html__( 'Seychelles', 'wp-any-contact-us' ),
			'SL'                                         => esc_html__( 'Sierra Leone', 'wp-any-contact-us' ),
			'Singapore'                                  => esc_html__( 'Singapore', 'wp-any-contact-us' ),
			'Slovakia'                                   => esc_html__( 'Slovakia', 'wp-any-contact-us' ),
			'Slovenia'                                   => esc_html__( 'Slovenia', 'wp-any-contact-us' ),
			'Solomon Islands'                            => esc_html__( 'Solomon Islands', 'wp-any-contact-us' ),
			'Somalia'                                    => esc_html__( 'Somalia', 'wp-any-contact-us' ),
			'South Africa'                               => esc_html__( 'South Africa', 'wp-any-contact-us' ),
			'South Georgia/Sandwich Islands'             => esc_html__( 'South Georgia/Sandwich Islands', 'wp-any-contact-us' ),
			'South Korea'                                => esc_html__( 'South Korea', 'wp-any-contact-us' ),
			'South Sudan'                                => esc_html__( 'South Sudan', 'wp-any-contact-us' ),
			'Spain'                                      => esc_html__( 'Spain', 'wp-any-contact-us' ),
			'Sri Lanka'                                  => esc_html__( 'Sri Lanka', 'wp-any-contact-us' ),
			'Sudan'                                      => esc_html__( 'Sudan', 'wp-any-contact-us' ),
			'Suriname'                                   => esc_html__( 'Suriname', 'wp-any-contact-us' ),
			'Svalbard and Jan Mayen'                     => esc_html__( 'Svalbard and Jan Mayen', 'wp-any-contact-us' ),
			'Swaziland'                                  => esc_html__( 'Swaziland', 'wp-any-contact-us' ),
			'Sweden'                                     => esc_html__( 'Sweden', 'wp-any-contact-us' ),
			'Switzerland'                                => esc_html__( 'Switzerland', 'wp-any-contact-us' ),
			'Syria'                                      => esc_html__( 'Syria', 'wp-any-contact-us' ),
			'Taiwan'                                     => esc_html__( 'Taiwan', 'wp-any-contact-us' ),
			'Tajikistan'                                 => esc_html__( 'Tajikistan', 'wp-any-contact-us' ),
			'Tanzania'                                   => esc_html__( 'Tanzania', 'wp-any-contact-us' ),
			'Thailand'                                   => esc_html__( 'Thailand', 'wp-any-contact-us' ),
			'Timor-Leste'                                => esc_html__( 'Timor-Leste', 'wp-any-contact-us' ),
			'Togo'                                       => esc_html__( 'Togo', 'wp-any-contact-us' ),
			'Tokelau'                                    => esc_html__( 'Tokelau', 'wp-any-contact-us' ),
			'Tonga'                                      => esc_html__( 'Tonga', 'wp-any-contact-us' ),
			'Trinidad and Tobago'                        => esc_html__( 'Trinidad and Tobago', 'wp-any-contact-us' ),
			'Tunisia'                                    => esc_html__( 'Tunisia', 'wp-any-contact-us' ),
			'Turkey'                                     => esc_html__( 'Turkey', 'wp-any-contact-us' ),
			'Turkmenistan'                               => esc_html__( 'Turkmenistan', 'wp-any-contact-us' ),
			'Turks and Caicos Islands'                   => esc_html__( 'Turks and Caicos Islands', 'wp-any-contact-us' ),
			'Tuvalu'                                     => esc_html__( 'Tuvalu', 'wp-any-contact-us' ),
			'Uganda'                                     => esc_html__( 'Uganda', 'wp-any-contact-us' ),
			'Ukraine'                                    => esc_html__( 'Ukraine', 'wp-any-contact-us' ),
			'United Arab Emirates'                       => esc_html__( 'United Arab Emirates', 'wp-any-contact-us' ),
			'United Kingdom (UK)'                        => esc_html__( 'United Kingdom (UK)', 'wp-any-contact-us' ),
			'United States (US)'                         => esc_html__( 'United States (US)', 'wp-any-contact-us' ),
			'United States (US) Minor Outlying Islands'  => esc_html__( 'United States (US) Minor Outlying Islands', 'wp-any-contact-us' ),
			'Uruguay'                                    => esc_html__( 'Uruguay', 'wp-any-contact-us' ),
			'Uzbekistan'                                 => esc_html__( 'Uzbekistan', 'wp-any-contact-us' ),
			'Vanuatu'                                    => esc_html__( 'Vanuatu', 'wp-any-contact-us' ),
			'Vatican'                                    => esc_html__( 'Vatican', 'wp-any-contact-us' ),
			'Venezuela'                                  => esc_html__( 'Venezuela', 'wp-any-contact-us' ),
			'Vietnam'                                    => esc_html__( 'Vietnam', 'wp-any-contact-us' ),
			'Virgin Islands (British)'                   => esc_html__( 'Virgin Islands (British)', 'wp-any-contact-us' ),
			'Virgin Islands (US)'                        => esc_html__( 'Virgin Islands (US)', 'wp-any-contact-us' ),
			'Wallis and Futuna'                          => esc_html__( 'Wallis and Futuna', 'wp-any-contact-us' ),
			'Western Sahara'                             => esc_html__( 'Western Sahara', 'wp-any-contact-us' ),
			'Samoa'                                      => esc_html__( 'Samoa', 'wp-any-contact-us' ),
			'Yemen'                                      => esc_html__( 'Yemen', 'wp-any-contact-us' ),
			'Zambia'                                     => esc_html__( 'Zambia', 'wp-any-contact-us' ),
			'Zimbabwe'                                   => esc_html__( 'Zimbabwe', 'wp-any-contact-us' ),
		) );

		$html .= "<select $name $inline_css >";

		foreach ( $countries as $country_key => $country_name ) {
			$html .= "<option value='{$country_key}'>{$country_name}</option>";
		}

		$html .= "</select>";

		echo $html;
	}

endif;

if ( ! function_exists( 'wacu_time_dropdown' ) ):
	function wacu_time_dropdown( $args = array() ) {
		$html = '';

		$inline_css = ( isset( $args['inline_css'] ) ) ? "style='{$args['inline_css']}'" : '';
		$selected   = ( isset( $args['selected'] ) ) ? $args['selected'] : '';
		$name       = ( isset( $args['name'] ) ) ? "name='{$args['name']}'" : '';
		$times      = array( '00:00', '00:30', '01:00', '01:30', '02:00', '02:30', '03:00', '03:30', '04:00', '04:30', '05:00', '05:30', '06:00', '06:30', '07:00', '07:30', '08:00', '08:30', '09:00', '09:30', '10:00', '10:30', '11:00', '11:30', '12:00', '12:30', '13:00', '13:30', '14:00', '14:30', '15:00', '15:30', '16:00', '16:30', '17:00', '17:30', '18:00', '18:30', '19:00', '19:30', '20:00', '20:30', '21:00', '21:30', '22:00', '22:30', '23:00', '23:30' );

		$html .= "<select $name $inline_css >";

		foreach ( $times as $time ) {
			if ( $time == $selected ):
				$html .= "<option value='{$time}' selected>{$time}</option>";
			else:
				$html .= "<option value='{$time}'>{$time}</option>";
			endif;

		}

		$html .= "</select>";

		echo $html;
	}

endif;

if ( ! function_exists( 'wacu_date_dropdown' ) ):
	function wacu_date_dropdown( $args = array() ) {
		$html = '';

		$inline_css = ( isset( $args['inline_css'] ) ) ? "style='{$args['inline_css']}'" : '';
		$selected   = ( isset( $args['selected'] ) ) ? $args['selected'] : '';
		$name       = ( isset( $args['name'] ) ) ? "name='{$args['name']}'" : '';
		$dates      = array( '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31' );

		$html .= "<select $name $inline_css >";

		foreach ( $dates as $date ) {
			if ( $date == $selected ):
				$html .= "<option value='{$date}' selected>{$date}</option>";
			else:
				$html .= "<option value='{$date}'>{$date}</option>";
			endif;

		}

		$html .= "</select>";

		echo $html;
	}

endif;

if ( ! function_exists( 'wacu_post_type_dropdown' ) ):
	function wacu_post_type_dropdown( $args = array() ) {
		global $wpdb;

		$html       = '';
		$name       = isset( $args['name'] ) ? 'name="' . $args['name'] . '"' : '';
		$id         = isset( $args['id'] ) ? $args['id'] : '';
		$multiple   = isset( $args['multiple'] ) && true === $args['multiple'] ? 'multiple' : '';
		$selected   = isset( $args['selected'] ) ? $args['selected'] : '';
		$post_types = array();

		// Add all option to the post types.
		$post_types['0']    = esc_html__( 'All Posts and Pages', 'wp-any-contact-us' );
		$post_types['post'] = esc_html__( 'Post', 'wp-any-contact-us' );
		$post_types['page'] = esc_html__( 'Page', 'wp-any-contact-us' );

		$post_types_args = array(
			'_builtin' => false,
			'public'   => true,
		);

		foreach ( get_post_types( $post_types_args, 'objects' ) as $post_type ) {
			$post_type_name              = $post_type->name;
			$post_type_label             = $post_type->labels->singular_name;
			$post_types[$post_type_name] = $post_type_label;
		}

		// Sort post type
		ksort( $post_types );

		// Add filter for modification.
		$post_types = apply_filters( 'wacu_post_types', $post_types, $post_types_args );

		$html .= "<select $id $name $multiple>";
		foreach ( $post_types as $post_type => $post_type_label ) {
			// Multiple
			if ( $selected && is_array( $selected ) ) {
				$select = in_array( $post_type, $selected ) ? 'selected' : '';
			} else { // Single
				$select = ( $post_type == $selected ) ? 'selected' : '';
			}

			$html .= "<option value='{$post_type}' $select>$post_type_label</option>";
		}
		$html .= "</select>";
		echo $html;
	}
endif;
