<?php
defined( 'ABSPATH' ) || exit;

class WACU_Integration_Wordpress_Whatsapp_Support {

	public function __construct() {
		if ( ! wacu_is_widget_display() ) {
			return;
		}
		if ( 'yes' !== wacu_integration_option( 'wordpress_whatsapp_support', 'status' ) ) {
			return;
		}

		add_action( 'wp_footer', array( $this, 'output' ), 70 );
		add_action( 'wp_enqueue_scripts', array( $this, 'inline_css' ), 250 );
	}

	public function output() {
		?>
		<script>
			;( function( $ ) {
				$( document ).ready( function() {

					$( document ).on( 'click', '[data-wacu-integration-trigger="wordpress_whatsapp_support"]', function() {
						$( '.wws-popup-container' ).css( {
							'visibility' : 'visible',
							'opacity' : '1',
						} );
						$( '.wacu-widget' ).hide();

						wwsWidget.open();
					} );

					$( document.body ).on( 'wws_widget_close', function() {
						setTimeout( function() {
							$( '.wws-popup-container' ).css( {
								'visibility' : 'hidden',
								'opacity' : '0',
							} );
							$( '.wacu-widget' ).show();

							wwsWidget.close();
						}, 500 );
					} );

				} );
			} )( jQuery )
		</script>
		<?php
	}

	public function inline_css() {
		$css = '.wws-popup-container {
			visibility: hidden;
			opacity: 0;
		}';

		wp_add_inline_style( 'wacu-style', $css );
	}

}

function wacu_integration_wordpress_whatsapp_support() {
	new WACU_Integration_Wordpress_Whatsapp_Support;
}
add_action( 'wp', 'wacu_integration_wordpress_whatsapp_support' );
