<?php
defined( 'ABSPATH' ) || exit;

class WACU_Gdpr {

	public function __construct() {
		if ( 'yes' !== wacu_gdpr_option( 'status' ) ) {
			return;
		}
		if ( 'wacu_before_popup_body' === wacu_gdpr_option( 'location' ) ) {
			add_action( 'wacu_before_popup_body', array( $this, 'display_gdpr' ), 30 );
		} else {
			add_action( 'wacu_after_popup_body', array( $this, 'display_gdpr' ), 30 );
		}
		add_filter( 'wacu_widget_classes', array( $this, 'add_widget_classes' ), 10, 1 );
	}

	public function display_gdpr() {
		$html = '';
		$html .= '<label for="wacu-gdpr-checkbox" class="wacu-gdpr-wrapper">';
		$html .= '<input type="checkbox" id="wacu-gdpr-checkbox">';
		$html .= str_replace(
			array(
				'{{privacy_page}}',
			),
			array(
				$this->get_privacy_page_link(),
			),
			esc_textarea( wacu_gdpr_option( 'message' ) )
		);
		$html .= '</label>';
		echo $html;
	}

	public function get_privacy_page_link() {
		$privacy_page_id    = wacu_gdpr_option( 'privacy_page' );
		$privacy_page_title = get_the_title( $privacy_page_id );
		$privacy_page_link  = get_permalink( $privacy_page_id );

		return sprintf( '<a href="%s">%s</a>', esc_url( $privacy_page_link ), esc_html( $privacy_page_title ) );
	}

	public function add_widget_classes( $classes ) {
		$classes[] = 'wacu-gdpr';

		return $classes;
	}

}

$wacu_gdpr = new WACU_Gdpr;
