<?php settings_fields( 'wacu_email_us_settings_option_group' ); ?>
<table class="form-table">
	<tbody>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings[label_full_name]"><?php esc_attr_e( 'Label For Full Name', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_email_us_settings[label_full_name]"
					class="regular-text"
					name="wacu_email_us_settings[label_full_name]"
					value="<?php echo esc_attr( wacu_email_us_option( 'label_full_name' ) ); ?>">
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings[label_email_address]"><?php esc_attr_e( 'Label For Email Address', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_email_us_settings[label_email_address]"
					class="regular-text"
					name="wacu_email_us_settings[label_email_address]"
					value="<?php echo esc_attr( wacu_email_us_option( 'label_email_address' ) ); ?>">
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings[label_email_message]"><?php esc_attr_e( 'Label For Email Message', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_email_us_settings[label_email_message]"
					class="regular-text"
					name="wacu_email_us_settings[label_email_message]"
					value="<?php echo esc_attr( wacu_email_us_option( 'label_email_message' ) ); ?>">
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings[label_button]"><?php esc_attr_e( 'Label For Button', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_email_us_settings[label_button]"
					class="regular-text"
					name="wacu_email_us_settings[label_button]"
					value="<?php echo esc_attr( wacu_email_us_option( 'label_button' ) ); ?>">
			</td>
		</tr>
		<tr>
			<td colspan="2"><hr></td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings[email_subject]"><?php esc_attr_e( 'Email Subject', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_email_us_settings[email_subject]"
					class="regular-text"
					name="wacu_email_us_settings[email_subject]"
					value="<?php echo esc_attr( wacu_email_us_option( 'email_subject' ) ); ?>">
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Full name.', 'wp-any-contact-us' ), '<code>{{name}}</code>' ); ?></p>
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Current Time.', 'wp-any-contact-us' ), '<code>{{current_time}}</code>' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings_email_body"><?php esc_html_e( 'Email Body', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<div style="width: 550px; max-width: 100%;">
					<?php
						wp_editor(
							wp_kses_post( wacu_email_us_option( 'email_body' ) ),
							'wacu_email_us_settings_email_body',
							array(
								'editor_height' => 200,
								'textarea_name' => 'wacu_email_us_settings[email_body]',
							)
						);
					?>
				</div>
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Full name.', 'wp-any-contact-us' ), '<code>{{name}}</code>' ); ?></p>
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Email.', 'wp-any-contact-us' ), '<code>{{email}}</code>' ); ?></p>
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Message.', 'wp-any-contact-us' ), '<code>{{message}}</code>' ); ?></p>
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Page Title.', 'wp-any-contact-us' ), '<code>{{page_title}}</code>' ); ?></p>
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Page URL.', 'wp-any-contact-us' ), '<code>{{page_url}}</code>' ); ?></p>
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Current Time.', 'wp-any-contact-us' ), '<code>{{current_time}}</code>' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings[email_to]"><?php esc_attr_e( 'Email To', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_email_us_settings[email_to]"
					class="regular-text"
					name="wacu_email_us_settings[email_to]"
					value="<?php echo esc_attr( wacu_email_us_option( 'email_to' ) ); ?>">
				<p class="description"><?php esc_html_e( 'Use comma (,) separator for multiple emails.', 'wp-any-contact-us' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings[email_cc]"><?php esc_attr_e( 'Email CC', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_email_us_settings[email_cc]"
					class="regular-text"
					name="wacu_email_us_settings[email_cc]"
					value="<?php echo esc_attr( wacu_email_us_option( 'email_cc' ) ); ?>">
				<p class="description"><?php esc_html_e( 'Use comma (,) separator for multiple emails.', 'wp-any-contact-us' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings[email_bcc]"><?php esc_attr_e( 'Email BCC', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_email_us_settings[email_bcc]"
					class="regular-text"
					name="wacu_email_us_settings[email_bcc]"
					value="<?php echo esc_attr( wacu_email_us_option( 'email_bcc' ) ); ?>">
				<p class="description"><?php esc_html_e( 'Use comma (,) separator for multiple emails.', 'wp-any-contact-us' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings[email_from_name]"><?php esc_attr_e( 'Email From Name', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_email_us_settings[email_from_name]"
					class="regular-text"
					name="wacu_email_us_settings[email_from_name]"
					value="<?php echo esc_attr( wacu_email_us_option( 'email_from_name' ) ); ?>">
				<p class="description"><?php printf( esc_html__( 'Best practice %s', 'wp-any-contact-us' ), '<code>' . get_bloginfo( 'name' ) . '</code>' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings[email_from_email]"><?php esc_attr_e( 'Email From Email', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					type="text"
					id="wacu_email_us_settings[email_from_email]"
					class="regular-text"
					name="wacu_email_us_settings[email_from_email]"
					value="<?php echo esc_attr( wacu_email_us_option( 'email_from_email' ) ); ?>">
				<p class="description"><?php printf( esc_html__( 'Best practice %s', 'wp-any-contact-us' ), '<code>' . get_bloginfo( 'admin_email' ) . '</code>' ); ?></p>
				<div style="margin-top: 10px;">
					<img src="<?php echo WACU_PLUGIN_URL . 'assets/images/email-us-img1.jpg'; ?>" alt="//">
				</div>
			</td>
		</tr>
		<tr>
			<td colspan="2"><hr></td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings_thank_you_message"><?php esc_html_e( 'Thank You Message', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<div style="width: 550px; max-width: 100%;">
					<?php
						wp_editor(
							wp_kses_post( wacu_email_us_option( 'thank_you_message' ) ),
							'wacu_email_us_settings_thank_you_message',
							array(
								'editor_height' => 200,
								'textarea_name' => 'wacu_email_us_settings[thank_you_message]',
							)
						);
					?>
				</div>
				<p class="description"><?php printf( esc_html__( 'Use tag %s for Full name.', 'wp-any-contact-us' ), '<code>{{name}}</code>' ); ?></p>
			</td>
		</tr>
		<tr>
			<td colspan="2"><hr></td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_email_us_settings[grecaptcha]"><?php esc_attr_e( 'Google reCAPTCHA v2', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<label for="wacu_email_us_settings[grecaptcha]">
					<input
						type="checkbox"
						id="wacu_email_us_settings[grecaptcha]"
						name="wacu_email_us_settings[grecaptcha]"
						value="yes"
						<?php checked( 'yes', wacu_email_us_option( 'grecaptcha' ) ); ?> >
						<span><?php esc_html_e( 'Enable/ Disable', 'wp-any-contact-us' ); ?></span>
					<p class="description">
					<?php
						echo wp_kses_post(
							sprintf(
								__( 'Enter Google reCAPTCHA v2 keys <a href="%s" target="_blank">here</a>', 'wp-any-contact-us' ),
								admin_url( 'admin.php?page=wp-any-contact-us_grecaptcha' )
							)
						);
					?>
					</p>
				</label>

			</td>
		</tr>
	</tbody>
</table>
<?php submit_button(); ?>
