<?php settings_fields( 'wacu_basic_settings_option_group' ); ?>
<table class="form-table">
	<tbody>
		<tr>
			<th scope="row">
				<label for="wacu_basic_settings[widget_status]"><?php esc_html_e( 'Widget', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					id="wacu_basic_settings[widget_status]"
					type="checkbox" <?php checked( 'yes', wacu_basic_setting_option( 'widget_status' ), true ); ?>
					name="wacu_basic_settings[widget_status]"> <label for="wacu_basic_settings[widget_status]"><?php esc_html_e( 'Enable/Disable', 'wp-any-contact-us' ); ?></label>
				<p class="description"><?php esc_html_e( 'You can enable or disable the widget completely.', 'wp-any-contact-us' ); ?></p>
			</td>
		</tr>
		<tr>
			<td colspan="2"><hr></td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_basic_settings[display_on_mobile]"><?php esc_html_e( 'Display On Mobile', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					id="wacu_basic_settings[display_on_mobile]"
					type="checkbox" <?php checked( 'yes', wacu_basic_setting_option( 'display_on_mobile' ), true ); ?>
					name="wacu_basic_settings[display_on_mobile]"> <label for="wacu_basic_settings[display_on_mobile]"><?php esc_html_e( 'Enable/Disable', 'wp-any-contact-us' ); ?></label>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_basic_settings[display_on_desktop]"><?php esc_html_e( 'Display On Desktop', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					id="wacu_basic_settings[display_on_desktop]"
					type="checkbox" <?php checked( 'yes', wacu_basic_setting_option( 'display_on_desktop' ), true ); ?>
					name="wacu_basic_settings[display_on_desktop]"> <label for="wacu_basic_settings[display_on_desktop]"><?php esc_html_e( 'Enable/Disable', 'wp-any-contact-us' ); ?></label>
			</td>
		</tr>
		<tr>
			<td colspan="2"><hr></td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_basic_settings[filter_by_everywhere]"><?php esc_html_e( 'Filter By Pages', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					id="wacu_basic_settings[filter_by_everywhere]"
					type="checkbox" <?php checked( 'yes', wacu_basic_setting_option( 'filter_by_everywhere' ), true ); ?>
					name="wacu_basic_settings[filter_by_everywhere]"> <label for="wacu_basic_settings[filter_by_everywhere]"><?php esc_html_e( 'Everywhere', 'wp-any-contact-us' ); ?></label>
					<p class="description"><?php esc_html_e( 'Display widget on all pages.', 'wp-any-contact-us' ); ?></p>
			</td>
		</tr>
		<tr>
			<th></th>
			<td>
				<p class="description"><?php esc_html_e( 'Include popup on Pages', 'wp-any-contact-us' ) ?></p>
				<?php
					wacu_page_dropdown(
						array(
							'multiple' => true,
							'name'     => 'wacu_basic_settings[filter_include_by_page][]',
							'class'    => 'wacu-select2 regular-text',
							'selected' => wacu_basic_setting_option( 'filter_include_by_page' ),
						)
					);
				?>
				<p class="description"><?php esc_html_e( 'Select pages, where you want to add WordPress Any Contact Us.', 'wp-any-contact-us' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_basic_settings[filter_by_regester_user]"><?php esc_html_e( 'Filter By Register User', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<input
					id="wacu_basic_settings[filter_by_regester_user]"
					type="checkbox" <?php checked( 'yes', wacu_basic_setting_option( 'filter_by_regester_user' ), true ); ?>
					name="wacu_basic_settings[filter_by_regester_user]"> <label for="wacu_basic_settings[filter_by_regester_user]"><?php esc_html_e( 'Enable/Disable', 'wp-any-contact-us' ); ?></label>
			</td>
		</tr>
		<tr>
			<td colspan="2"><hr></td>
		</tr>
		<tr>
			<th scope="row">
				<label for="wacu_basic_settings[custom_css]"><?php esc_html_e( 'Custom CSS', 'wp-any-contact-us' ); ?></label>
			</th>
			<td>
				<textarea name="wacu_basic_settings[custom_css]" id="wacu_basic_settings[custom_css]" class="wacu-custom-css"><?php echo wp_kses_post( wacu_basic_setting_option( 'custom_css' ) ); ?></textarea>
			</td>
		</tr>
	</tbody>
</table>
<?php submit_button();?>
