<?php defined( 'ABSPATH' ) || exit; ?>
<div class="wrap">
	<h1><?php esc_html_e( 'Smart Messages', 'wp-any-contact-us' ); ?></h1>
	<?php settings_errors(); ?>
	<hr>
	<form action="options.php" method="post">
		<?php settings_fields( 'wacu_smart_popup_settings_option_group' ); ?>
		<table class="form-table">
			<tbody>
				<tr>
					<th scope="row">
						<label for="wacu_smart_popup_settings[status]"><?php esc_html_e( 'Smart Popup', 'wp-any-contact-us' ); ?></label>
					</th>
					<td>
						<input
							type="checkbox"
							name="wacu_smart_popup_settings[status]"
							id="wacu_smart_popup_settings[status]"
							<?php checked( 'yes', wacu_smart_popup_option( 'status' ), true ); ?>>
						<label for="wacu_smart_popup_settings[status]">
							<?php esc_html_e( 'Enable/Disable', 'wp-any-contact-us' ); ?>
						</label>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="wacu_smart_popup_settings[delay]"><?php esc_html_e( 'Smart Popup Delay', 'wp-any-contact-us' );?></label>
					</th>
					<td>
						<input
							type="number"
							name="wacu_smart_popup_settings[delay]"
							id="wacu_smart_popup_settings[delay]"
							class="small-text"
							value="<?php echo esc_attr( wacu_smart_popup_option( 'delay' ) ); ?>"
							min="0"
							step="1">
						<p class="description"><?php printf( esc_html__( 'In Seconds, Default %s seconds', 'wp-any-contact-us' ), '<code>5</code>' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="wacu_smart_popup_settings[interval]"><?php esc_html_e( 'Smart Popup Interval', 'wp-any-contact-us' );?></label>
					</th>
					<td>
						<input
							type="number"
							name="wacu_smart_popup_settings[interval]"
							id="wacu_smart_popup_settings[interval]"
							class="small-text"
							value="<?php echo esc_attr( wacu_smart_popup_option( 'interval' ) ); ?>"
							min="0"
							step="1">
						<div class="button" onClick="(function() { localStorage.removeItem( 'wacuSmartMessageInterval' ); })(); return false;"><?php esc_html_e( 'Reset smart popup', 'wp-any-contact-us' ); ?></div>
						<p class="description"><?php printf( esc_html__( 'In Seconds, Default %s (5 minutes)', 'wp-any-contact-us' ), '<code>300</code>' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="wacu_smart_popup_settings[typing_time]"><?php esc_html_e( 'Typing Time', 'wp-any-contact-us' );?></label>
					</th>
					<td>
						<input
							type="number"
							name="wacu_smart_popup_settings[typing_time]"
							id="wacu_smart_popup_settings[typing_time]"
							class="small-text"
							value="<?php echo esc_attr( wacu_smart_popup_option( 'typing_time' ) ); ?>"
							min="0"
							step="1">
						<p class="description"><?php printf( esc_html__( 'In Seconds, Default %s seconds', 'wp-any-contact-us' ), '<code>2</code>' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="wacu_smart_popup_settings[message_time]"><?php esc_html_e( 'Message Time', 'wp-any-contact-us' );?></label>
					</th>
					<td>
						<input
							type="number"
							name="wacu_smart_popup_settings[message_time]"
							id="wacu_smart_popup_settings[message_time]"
							class="small-text"
							value="<?php echo esc_attr( wacu_smart_popup_option( 'message_time' ) ); ?>"
							min="0"
							step="1">
						<p class="description"><?php printf( esc_html__( 'In Seconds, Default %s seconds', 'wp-any-contact-us' ), '<code>4</code>' ); ?></p>
					</td>
				</tr>
			</tbody>
		</table>
		<?php submit_button(); ?>
	</form>

	<table class="form-table">
		<tbody>
			<tr>
				<td colspan="2"><hr></td>
			</tr>
			<tr>
				<th scope="row">
					<label for=""><?php esc_html_e( 'Smart Message', 'wp-any-contact-us' ); ?></label>
				</th>
				<td>
					<a class="button" href="javascript:;" data-wacu-model-trigger="add-smart-message"><?php esc_html_e( 'Add Smart Message', 'wp-any-contact-us' ); ?></a>
				</td>
			</tr>
		</tbody>
	</table>

	<table class="wp-list-table widefat striped" id="wacu-admin-smart-message-table">
		<thead>
			<tr>
				<th scope="col" class="manage-column column-description" width="160"><?php esc_html_e( 'Position', 'wp-any-contact-us') ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Message', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Post Type', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description" width="140"><?php esc_html_e( 'Status', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description" width="140"><?php esc_html_e( 'Action', 'wp-any-contact-us' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php if ( wacu_get_smart_messages() ): ?>
				<?php foreach ( wacu_get_smart_messages() as $sm ): ?>
					<tr data-wacu-sm-id="<?php echo intval( $sm['id'] ); ?>">
						<td class="wacu-sm-position">
							<div><?php echo WACU_Icon::get( 'arrows-alt-v' ); ?></div>
						</td>
						<td class="wacu-sm-message"><?php echo wp_kses_post( $sm['message'] ); ?></td>
						<td class="wacu-sm-post-type">
							<?php if ( '0' === $sm['post_type'] ): ?>
								<?php esc_html_e( 'Everywhere', 'wp-any-contact-us' ); ?>
							<?php else: ?>
								<?php
									$sm_post_type = get_post_type_object( $sm['post_type'] );
									echo esc_html( $sm_post_type->labels->singular_name );
								?>
							<?php endif; ?>
						</td>
						<td class="wacu-sm-status">
							<div
								data-wacu-disable-smart-message="<?php echo absint( $sm['id'] ); ?>"
								data-wacu-tooltip="<?php esc_html_e( 'Click to disable', 'wp-any-contact-us' ) ?>"
								style="color: #455a64; <?php echo ( 1 == $sm['status'] ) ? 'display: block;' : 'display: none'; ?>">
								<?php echo WACU_Icon::get( 'eye' ); ?>
							</div>
							<div
								data-wacu-enable-smart-message="<?php echo absint( $sm['id'] ); ?>"
								data-wacu-tooltip="<?php esc_html_e( 'Click to enable', 'wp-any-contact-us' ) ?>"
								style="color: #b3c9d5; <?php echo ( 0 == $sm['status'] ) ? 'display: block;' : 'display: none'; ?>">
								<?php echo WACU_Icon::get( 'eye-slash' ); ?>
							</div>
						</td>
						<td class="wacu-sm-action">
							<a
								href="javascript:;"
								data-wacu-model-trigger="edit-smart-message"
								data-wacu-edit-smart-message="<?php echo absint( $sm['id'] ); ?>"
								data-wacu-tooltip="<?php esc_attr_e( 'Edit', 'wp-any-contact-us' ); ?>">
								<?php echo WACU_Icon::get( 'edit' ); ?>
							</a>
							<a
								href="javascript:;"
								onclick="return confirm( '<?php esc_html_e( 'Are you sure to delete this item?', 'wp-any-contact-us' ); ?>' )"
								data-wacu-delete-smart-message="<?php echo absint( $sm['id'] ); ?>"
								data-wacu-tooltip="<?php esc_attr_e( 'Delete', 'wp-any-contact-us' ); ?>">
								<?php echo WACU_Icon::get( 'trash' ); ?>
							</a>
						</td>
					</tr>
				<?php endforeach; ?>
			<?php endif; ?>
		</tbody>
		<tfoot>
			<tr>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Position', 'wp-any-contact-us') ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Message', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Post Type', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Status', 'wp-any-contact-us' ); ?></th>
				<th scope="col" class="manage-column column-description"><?php esc_html_e( 'Action', 'wp-any-contact-us' ); ?></th>
			</tr>
		</tfoot>
	</table>

</div>

<!-- Add smart message modal -->
<?php require_once WACU_PLUGIN_PATH . 'includes/admin/views/html-wacu-add-smart-message.php'; ?>
<!-- .Add smart message modal -->

<!-- Edit smart message modal -->
<div class="wacu-model" data-wacu-modal="edit-smart-message">
	<div class="wacu-modal-content">
		<div class="wacu-modal-header">
			<?php esc_html_e( 'Edit Smart Message', 'wp-any-contact-us' ); ?>
		</div>
		<div class="wacu-modal-body" id="edit-smart-message">
			<div class="wacu-folding-cube">
				<div class="wacu-cube1 wacu-cube"></div>
				<div class="wacu-cube2 wacu-cube"></div>
				<div class="wacu-cube4 wacu-cube"></div>
				<div class="wacu-cube3 wacu-cube"></div>
			</div>
		</div>
	</div>
</div>
<!-- .Edit smart message modal -->
