<div class="wacu-model" data-wacu-modal="add-smart-message">
	<div class="wacu-modal-content">
		<div class="wacu-modal-header">
			<?php esc_html_e( 'Add Smart Message', 'wp-any-contact-us' ); ?>
		</div>
		<form action="#" method="post">
			<?php wp_nonce_field( 'wacu_add_smart_message_submit', 'wacu_add_smart_message_security' ); ?>
			<div class="wacu-modal-body">
				<div class="wacu-row">
					<div class="wacu-col-100">
						<div class="wacu-admin-form__field">
							<label><?php esc_html_e( 'Message', 'wp-any-contact-us' ); ?></label>
							<textarea name="wacu_add_smart_message[message]"></textarea>
						</div>
						<div>
							<p><strong><?php esc_html_e( 'Variables:', 'wp-any-contact-us' ); ?></strong></p>
							<p><?php printf( esc_html__( '%s use for display page title.', 'wp-any-contact-us' ), '<code>{{page_title}}</code>' ); ?></p>
							<p><?php printf( esc_html__( '%s use for display currnet page URL.', 'wp-any-contact-us' ), '<code>{{page_url}}</code>' ); ?></p>
						</div>
					</div>
				</div>
				<div class="wacu-row">
					<div class="wacu-col-100">
						<div class="wacu-admin-form__field">
							<h3><?php esc_html_e( 'Conditional Display', 'wp-any-contact-us' ) ?></h3>
							<label><?php esc_html_e( 'Post Type', 'wp-any-contact-us' ); ?></label>
							<?php
								wacu_post_type_dropdown(
									array(
										'name' => 'wacu_add_smart_message[post_type]',
									)
								);
							?>
						</div>
					</div>
				</div>
			</div>
			<div class="wacu-modal-footer">
				<a href="#" class="button wacu-modal-close"><?php esc_attr_e( 'Cancel', 'wp-any-contact-us' ); ?></a>
				<input type="submit" name="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', 'wp-any-contact-us' ); ?>">
			</div>
		</form>
	</div>
</div>
